/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java8.util.Optional;
import org.everit.json.schema.ConditionalSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.AbstractSchemaExtractor;
import org.everit.json.schema.loader.ArraySchemaLoader;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.ObjectSchemaLoader;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$1;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$2;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$3;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$4;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$5;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$6;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$7;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$8;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor$$Lambda$9;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.StringSchemaLoader;

class PropertySnifferSchemaExtractor
extends AbstractSchemaExtractor {
    static final List<String> CONDITIONAL_SCHEMA_KEYWORDS = Arrays.asList("if", "then", "else");

    PropertySnifferSchemaExtractor(SchemaLoader defaultLoader) {
        super(defaultLoader);
    }

    @Override
    List<Schema.Builder<?>> extract() {
        ArrayList builders = new ArrayList(1);
        if (this.schemaHasAnyOf(this.config().specVersion.arrayKeywords())) {
            builders.add(new ArraySchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load().requiresArray(false));
        }
        if (this.schemaHasAnyOf(this.config().specVersion.objectKeywords())) {
            builders.add(new ObjectSchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load().requiresObject(false));
        }
        if (this.schemaHasAnyOf(NUMBER_SCHEMA_PROPS)) {
            builders.add(this.buildNumberSchema().requiresNumber(false));
        }
        if (this.schemaHasAnyOf(STRING_SCHEMA_PROPS)) {
            builders.add(new StringSchemaLoader(this.schemaJson.ls, this.config().formatValidators).load().requiresString(false));
        }
        if (this.config().specVersion.isAtLeast(SpecificationVersion.DRAFT_7) && this.schemaHasAnyOf(CONDITIONAL_SCHEMA_KEYWORDS)) {
            builders.add(this.buildConditionalSchema());
        }
        return builders;
    }

    private ConditionalSchema.Builder buildConditionalSchema() {
        ConditionalSchema.Builder builder = ConditionalSchema.builder();
        Optional<JsonValue> optional = this.maybe("if");
        SchemaLoader schemaLoader = this.defaultLoader;
        schemaLoader.getClass();
        Optional optional2 = optional.map(PropertySnifferSchemaExtractor$$Lambda$1.lambdaFactory$(schemaLoader)).map(PropertySnifferSchemaExtractor$$Lambda$2.lambdaFactory$());
        ConditionalSchema.Builder builder2 = builder;
        builder2.getClass();
        optional2.ifPresent(PropertySnifferSchemaExtractor$$Lambda$3.lambdaFactory$(builder2));
        Optional<JsonValue> optional3 = this.maybe("then");
        SchemaLoader schemaLoader2 = this.defaultLoader;
        schemaLoader2.getClass();
        Optional optional4 = optional3.map(PropertySnifferSchemaExtractor$$Lambda$4.lambdaFactory$(schemaLoader2)).map(PropertySnifferSchemaExtractor$$Lambda$5.lambdaFactory$());
        ConditionalSchema.Builder builder3 = builder;
        builder3.getClass();
        optional4.ifPresent(PropertySnifferSchemaExtractor$$Lambda$6.lambdaFactory$(builder3));
        Optional<JsonValue> optional5 = this.maybe("else");
        SchemaLoader schemaLoader3 = this.defaultLoader;
        schemaLoader3.getClass();
        Optional optional6 = optional5.map(PropertySnifferSchemaExtractor$$Lambda$7.lambdaFactory$(schemaLoader3)).map(PropertySnifferSchemaExtractor$$Lambda$8.lambdaFactory$());
        ConditionalSchema.Builder builder4 = builder;
        builder4.getClass();
        optional6.ifPresent(PropertySnifferSchemaExtractor$$Lambda$9.lambdaFactory$(builder4));
        return builder;
    }
}

