/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.everit.json.schema.BooleanSchema;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.AbstractSchemaExtractor;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.StringSchemaLoader;
import org.everit.json.schema.loader.TypeBasedSchemaExtractor$$Lambda$1;
import org.everit.json.schema.loader.TypeBasedSchemaExtractor$$Lambda$2;
import org.everit.json.schema.loader.TypeBasedSchemaExtractor$$Lambda$3;

class TypeBasedSchemaExtractor
extends AbstractSchemaExtractor {
    TypeBasedSchemaExtractor(SchemaLoader defaultLoader) {
        super(defaultLoader);
    }

    @Override
    List<Schema.Builder<?>> extract() {
        if (this.containsKey("type")) {
            return Collections.singletonList(this.require("type").canBeMappedTo(JsonArray.class, TypeBasedSchemaExtractor$$Lambda$1.lambdaFactory$(this)).orMappedTo(String.class, TypeBasedSchemaExtractor$$Lambda$2.lambdaFactory$(this)).requireAny());
        }
        return Collections.emptyList();
    }

    private CombinedSchema.Builder buildAnyOfSchemaForMultipleTypes() {
        JsonArray subtypeJsons = this.require("type").requireArray();
        ArrayList<Schema> subschemas = new ArrayList<Schema>(subtypeJsons.length());
        subtypeJsons.forEach(TypeBasedSchemaExtractor$$Lambda$3.lambdaFactory$(this, subschemas));
        return CombinedSchema.anyOf(subschemas);
    }

    private Schema.Builder<?> loadForExplicitType(String typeString) {
        String string = typeString;
        int n = -1;
        switch (string.hashCode()) {
            case -891985903: {
                if (!string.equals("string")) break;
                n = 0;
                break;
            }
            case 1958052158: {
                if (!string.equals("integer")) break;
                n = 1;
                break;
            }
            case -1034364087: {
                if (!string.equals("number")) break;
                n = 2;
                break;
            }
            case 64711720: {
                if (!string.equals("boolean")) break;
                n = 3;
                break;
            }
            case 3392903: {
                if (!string.equals("null")) break;
                n = 4;
                break;
            }
            case 93090393: {
                if (!string.equals("array")) break;
                n = 5;
                break;
            }
            case -1023368385: {
                if (!string.equals("object")) break;
                n = 6;
            }
        }
        switch (n) {
            case 0: {
                this.keysConsumed(PropertySnifferSchemaExtractor.STRING_SCHEMA_PROPS);
                return new StringSchemaLoader(this.schemaJson.ls, this.config().formatValidators).load();
            }
            case 1: {
                return this.buildNumberSchema().requiresInteger(true);
            }
            case 2: {
                return this.buildNumberSchema();
            }
            case 3: {
                return BooleanSchema.builder();
            }
            case 4: {
                return NullSchema.builder();
            }
            case 5: {
                return this.buildArraySchema();
            }
            case 6: {
                return this.buildObjectSchema();
            }
        }
        throw new SchemaException(this.schemaJson.ls.locationOfCurrentObj(), String.format("unknown type: [%s]", typeString));
    }

    static /* synthetic */ void lambda$buildAnyOfSchemaForMultipleTypes$1(TypeBasedSchemaExtractor this_, Collection subschemas, int j, JsonValue raw) {
        subschemas.add(this_.loadForExplicitType(raw.requireString()).build());
    }

    static /* synthetic */ Schema.Builder lambda$extract$0(TypeBasedSchemaExtractor this_, JsonArray arr) {
        return this_.buildAnyOfSchemaForMultipleTypes();
    }

    static /* synthetic */ Schema.Builder access$lambda$0(TypeBasedSchemaExtractor typeBasedSchemaExtractor, String string) {
        return typeBasedSchemaExtractor.loadForExplicitType(string);
    }
}

