/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.ContainerAuthFilter;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.httpd.ProjectBasicAuthFilter;
import com.google.gerrit.httpd.ProjectDigestFilter;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.DownloadConfig;
import com.google.inject.Inject;
import com.google.inject.servlet.ServletModule;

public class GitOverHttpModule
extends ServletModule {
    private final AuthConfig authConfig;
    private final DownloadConfig downloadConfig;

    @Inject
    GitOverHttpModule(AuthConfig authConfig, DownloadConfig downloadConfig) {
        this.authConfig = authConfig;
        this.downloadConfig = downloadConfig;
    }

    @Override
    protected void configureServlets() {
        Class authFilter = this.authConfig.isTrustContainerAuth() ? ContainerAuthFilter.class : (this.authConfig.isGitBasicAuth() ? ProjectBasicAuthFilter.class : ProjectDigestFilter.class);
        if (this.isHttpEnabled()) {
            String git = GitOverHttpServlet.URL_REGEX;
            this.filterRegex(git, new String[0]).through(authFilter);
            this.serveRegex(git, new String[0]).with(GitOverHttpServlet.class);
        }
        this.filter("/a/*", new String[0]).through(authFilter);
    }

    private boolean isHttpEnabled() {
        return this.downloadConfig.getDownloadSchemes().contains((Object)AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS) || this.downloadConfig.getDownloadSchemes().contains((Object)AccountGeneralPreferences.DownloadScheme.ANON_HTTP) || this.downloadConfig.getDownloadSchemes().contains((Object)AccountGeneralPreferences.DownloadScheme.HTTP);
    }
}

