/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.UserConfig;

@Singleton
public class GerritPersonIdentProvider
implements Provider<PersonIdent> {
    private final String name;
    private final String email;

    @Inject
    public GerritPersonIdentProvider(@GerritServerConfig Config cfg) {
        String name = cfg.getString("user", null, "name");
        if (name == null) {
            name = "Gerrit Code Review";
        }
        this.name = name;
        this.email = cfg.get(UserConfig.KEY).getCommitterEmail();
    }

    @Override
    public PersonIdent get() {
        return new PersonIdent(this.name, this.email);
    }
}

