/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccountCacheImpl
implements AccountCache {
    private static final Logger log = LoggerFactory.getLogger(AccountCacheImpl.class);
    private static final String BYID_NAME = "accounts";
    private static final String BYUSER_NAME = "accounts_byname";
    private final LoadingCache<Account.Id, AccountState> byId;
    private final LoadingCache<String, Optional<Account.Id>> byName;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(AccountCacheImpl.BYID_NAME, Account.Id.class, AccountState.class).loader(ByIdLoader.class);
                this.cache(AccountCacheImpl.BYUSER_NAME, String.class, new TypeLiteral<Optional<Account.Id>>(){}).loader(ByNameLoader.class);
                this.bind(AccountCacheImpl.class);
                this.bind(AccountCache.class).to(AccountCacheImpl.class);
            }
        };
    }

    @Inject
    AccountCacheImpl(@Named(value="accounts") LoadingCache<Account.Id, AccountState> byId, @Named(value="accounts_byname") LoadingCache<String, Optional<Account.Id>> byUsername) {
        this.byId = byId;
        this.byName = byUsername;
    }

    @Override
    public AccountState get(Account.Id accountId) {
        try {
            return this.byId.get(accountId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load AccountState for " + accountId, e);
            return AccountCacheImpl.missing(accountId);
        }
    }

    @Override
    public AccountState getIfPresent(Account.Id accountId) {
        return (AccountState)this.byId.getIfPresent(accountId);
    }

    @Override
    public AccountState getByUsername(String username) {
        try {
            Optional<Account.Id> id = this.byName.get(username);
            return id != null && id.isPresent() ? this.byId.get(id.get()) : null;
        }
        catch (ExecutionException e) {
            log.warn("Cannot load AccountState for " + username, e);
            return null;
        }
    }

    @Override
    public void evict(Account.Id accountId) {
        if (accountId != null) {
            this.byId.invalidate(accountId);
        }
    }

    @Override
    public void evictByUsername(String username) {
        if (username != null) {
            this.byName.invalidate(username);
        }
    }

    private static AccountState missing(Account.Id accountId) {
        Account account = new Account(accountId, TimeUtil.nowTs());
        Set<AccountExternalId> ids = Collections.emptySet();
        ImmutableSet<AccountGroup.UUID> anon = ImmutableSet.of();
        return new AccountState(account, anon, ids);
    }

    static class ByNameLoader
    extends CacheLoader<String, Optional<Account.Id>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ByNameLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Account.Id> load(String username) throws Exception {
            try (ReviewDb db = this.schema.open();){
                AccountExternalId.Key key = new AccountExternalId.Key("username:", username);
                AccountExternalId id = db.accountExternalIds().get(key);
                if (id != null) {
                    Optional<Account.Id> optional = Optional.of(id.getAccountId());
                    return optional;
                }
                Optional<Account.Id> optional = Optional.absent();
                return optional;
            }
        }
    }

    static class ByIdLoader
    extends CacheLoader<Account.Id, AccountState> {
        private final SchemaFactory<ReviewDb> schema;
        private final GroupCache groupCache;
        private final LoadingCache<String, Optional<Account.Id>> byName;

        @Inject
        ByIdLoader(SchemaFactory<ReviewDb> sf, GroupCache groupCache, @Named(value="accounts_byname") LoadingCache<String, Optional<Account.Id>> byUsername) {
            this.schema = sf;
            this.groupCache = groupCache;
            this.byName = byUsername;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccountState load(Account.Id key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                AccountState state = this.load(db, key);
                String user = state.getUserName();
                if (user != null) {
                    this.byName.put(user, Optional.of(state.getAccount().getId()));
                }
                AccountState accountState = state;
                return accountState;
            }
        }

        private AccountState load(ReviewDb db, Account.Id who) throws OrmException {
            Account account = db.accounts().get(who);
            if (account == null) {
                return AccountCacheImpl.missing(who);
            }
            Collection<AccountExternalId> externalIds = Collections.unmodifiableCollection(db.accountExternalIds().byAccount(who).toList());
            HashSet<AccountGroup.UUID> internalGroups = new HashSet();
            for (AccountGroupMember g : db.accountGroupMembers().byAccount(who)) {
                AccountGroup.Id groupId = g.getAccountGroupId();
                AccountGroup group = this.groupCache.get(groupId);
                if (group == null || group.getGroupUUID() == null) continue;
                internalGroups.add(group.getGroupUUID());
            }
            internalGroups = Collections.unmodifiableSet(internalGroups);
            return new AccountState(account, internalGroups, externalIds);
        }
    }
}

