/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountExternalId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.Realm;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Singleton
public class AccountResolver {
    private final Realm realm;
    private final AccountByEmailCache byEmail;
    private final AccountCache byId;
    private final Provider<ReviewDb> schema;

    @Inject
    AccountResolver(Realm realm, AccountByEmailCache byEmail, AccountCache byId, Provider<ReviewDb> schema) {
        this.realm = realm;
        this.byEmail = byEmail;
        this.byId = byId;
        this.schema = schema;
    }

    public Account find(String nameOrEmail) throws OrmException {
        Set<Account.Id> r = this.findAll(nameOrEmail);
        if (r.size() == 1) {
            return this.byId.get(r.iterator().next()).getAccount();
        }
        Account match = null;
        for (Account.Id id : r) {
            Account account = this.byId.get(id).getAccount();
            if (!account.isActive()) continue;
            if (match != null) {
                return null;
            }
            match = account;
        }
        return match;
    }

    public Set<Account.Id> findAll(String nameOrEmail) throws OrmException {
        AccountState who;
        Matcher m = Pattern.compile("^.* \\(([1-9][0-9]*)\\)$").matcher(nameOrEmail);
        if (m.matches()) {
            Account.Id id = Account.Id.parse(m.group(1));
            if (this.exists(id)) {
                return Collections.singleton(id);
            }
            return Collections.emptySet();
        }
        if (nameOrEmail.matches("^[1-9][0-9]*$")) {
            Account.Id id = Account.Id.parse(nameOrEmail);
            if (this.exists(id)) {
                return Collections.singleton(id);
            }
            return Collections.emptySet();
        }
        if (nameOrEmail.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$") && (who = this.byId.getByUsername(nameOrEmail)) != null) {
            return Collections.singleton(who.getAccount().getId());
        }
        return this.findAllByNameOrEmail(nameOrEmail);
    }

    private boolean exists(Account.Id id) throws OrmException {
        return this.schema.get().accounts().get(id) != null;
    }

    public Account findByNameOrEmail(String nameOrEmail) throws OrmException {
        Set<Account.Id> r = this.findAllByNameOrEmail(nameOrEmail);
        return r.size() == 1 ? this.byId.get(r.iterator().next()).getAccount() : null;
    }

    public Set<Account.Id> findAllByNameOrEmail(String nameOrEmail) throws OrmException {
        int lt = nameOrEmail.indexOf(60);
        int gt = nameOrEmail.indexOf(62);
        if (lt >= 0 && gt > lt && nameOrEmail.contains("@")) {
            Set<Account.Id> ids = this.byEmail.get(nameOrEmail.substring(lt + 1, gt));
            if (ids.isEmpty() || ids.size() == 1) {
                return ids;
            }
            String name = nameOrEmail.substring(0, lt - 1);
            HashSet<Account.Id> nameMatches = Sets.newHashSet();
            for (Account.Id id : ids) {
                Account a = this.byId.get(id).getAccount();
                if (!name.equals(a.getFullName())) continue;
                nameMatches.add(id);
            }
            return nameMatches.isEmpty() ? ids : nameMatches;
        }
        if (nameOrEmail.contains("@")) {
            return this.byEmail.get(nameOrEmail);
        }
        Account.Id id = this.realm.lookup(nameOrEmail);
        if (id != null) {
            return Collections.singleton(id);
        }
        List<Account> m = this.schema.get().accounts().byFullName(nameOrEmail).toList();
        if (m.size() == 1) {
            return Collections.singleton(m.get(0).getId());
        }
        HashSet<Account.Id> result = new HashSet<Account.Id>();
        String a = nameOrEmail;
        String b = nameOrEmail + "\u9fa5";
        for (Account act : this.schema.get().accounts().suggestByFullName(a, b, 10)) {
            result.add(act.getId());
        }
        for (AccountExternalId extId : this.schema.get().accountExternalIds().suggestByKey(new AccountExternalId.Key("username:", a), new AccountExternalId.Key("username:", b), 10)) {
            result.add(extId.getAccountId());
        }
        for (AccountExternalId extId : this.schema.get().accountExternalIds().suggestByEmailAddress(a, b, 10)) {
            result.add(extId.getAccountId());
        }
        return result;
    }
}

