/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.IncludingGroupMembership;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;

@Singleton
public class InternalGroupBackend
implements GroupBackend {
    private static final Function<AccountGroup, GroupReference> ACT_GROUP_TO_GROUP_REF = new Function<AccountGroup, GroupReference>(){

        @Override
        public GroupReference apply(AccountGroup group) {
            return GroupReference.forGroup(group);
        }
    };
    private final GroupControl.Factory groupControlFactory;
    private final GroupCache groupCache;
    private final IncludingGroupMembership.Factory groupMembershipFactory;

    @Inject
    InternalGroupBackend(GroupControl.Factory groupControlFactory, GroupCache groupCache, IncludingGroupMembership.Factory groupMembershipFactory) {
        this.groupControlFactory = groupControlFactory;
        this.groupCache = groupCache;
        this.groupMembershipFactory = groupMembershipFactory;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return AccountGroup.isInternalGroup(uuid);
    }

    @Override
    public GroupDescription.Internal get(AccountGroup.UUID uuid) {
        if (!this.handles(uuid)) {
            return null;
        }
        AccountGroup g = this.groupCache.get(uuid);
        if (g == null) {
            return null;
        }
        return GroupDescriptions.forAccountGroup(g);
    }

    @Override
    public Collection<GroupReference> suggest(final String name, ProjectControl project) {
        Iterable<AccountGroup> filtered = Iterables.filter(this.groupCache.all(), new Predicate<AccountGroup>(){

            @Override
            public boolean apply(AccountGroup group) {
                return group.getName().regionMatches(true, 0, name, 0, name.length()) && InternalGroupBackend.this.groupControlFactory.controlFor(group).isVisible();
            }
        });
        return Lists.newArrayList(Iterables.transform(filtered, ACT_GROUP_TO_GROUP_REF));
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return this.groupMembershipFactory.create(user);
    }
}

