/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestApiModule;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.AddSshKey;
import com.google.gerrit.server.account.Capabilities;
import com.google.gerrit.server.account.CreateAccount;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.DeleteActive;
import com.google.gerrit.server.account.DeleteEmail;
import com.google.gerrit.server.account.DeleteSshKey;
import com.google.gerrit.server.account.Emails;
import com.google.gerrit.server.account.GetAccount;
import com.google.gerrit.server.account.GetActive;
import com.google.gerrit.server.account.GetAvatar;
import com.google.gerrit.server.account.GetAvatarChangeUrl;
import com.google.gerrit.server.account.GetCapabilities;
import com.google.gerrit.server.account.GetDiffPreferences;
import com.google.gerrit.server.account.GetEmail;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GetHttpPassword;
import com.google.gerrit.server.account.GetName;
import com.google.gerrit.server.account.GetPreferences;
import com.google.gerrit.server.account.GetSshKey;
import com.google.gerrit.server.account.GetUsername;
import com.google.gerrit.server.account.PutAccount;
import com.google.gerrit.server.account.PutActive;
import com.google.gerrit.server.account.PutEmail;
import com.google.gerrit.server.account.PutHttpPassword;
import com.google.gerrit.server.account.PutName;
import com.google.gerrit.server.account.PutPreferred;
import com.google.gerrit.server.account.SetDiffPreferences;
import com.google.gerrit.server.account.SetPreferences;
import com.google.gerrit.server.account.SshKeys;
import com.google.gerrit.server.account.StarredChanges;
import com.google.inject.assistedinject.FactoryModuleBuilder;

public class Module
extends RestApiModule {
    @Override
    protected void configure() {
        this.bind(AccountsCollection.class);
        this.bind(Capabilities.class);
        DynamicMap.mapOf(this.binder(), AccountResource.ACCOUNT_KIND);
        DynamicMap.mapOf(this.binder(), AccountResource.CAPABILITY_KIND);
        DynamicMap.mapOf(this.binder(), AccountResource.EMAIL_KIND);
        DynamicMap.mapOf(this.binder(), AccountResource.SSH_KEY_KIND);
        DynamicMap.mapOf(this.binder(), AccountResource.STARRED_CHANGE_KIND);
        this.put(AccountResource.ACCOUNT_KIND).to(PutAccount.class);
        this.get(AccountResource.ACCOUNT_KIND).to(GetAccount.class);
        this.get(AccountResource.ACCOUNT_KIND, "name").to(GetName.class);
        this.put(AccountResource.ACCOUNT_KIND, "name").to(PutName.class);
        this.delete(AccountResource.ACCOUNT_KIND, "name").to(PutName.class);
        this.get(AccountResource.ACCOUNT_KIND, "username").to(GetUsername.class);
        this.get(AccountResource.ACCOUNT_KIND, "active").to(GetActive.class);
        this.put(AccountResource.ACCOUNT_KIND, "active").to(PutActive.class);
        this.delete(AccountResource.ACCOUNT_KIND, "active").to(DeleteActive.class);
        this.child(AccountResource.ACCOUNT_KIND, "emails").to(Emails.class);
        this.get(AccountResource.EMAIL_KIND).to(GetEmail.class);
        this.put(AccountResource.EMAIL_KIND).to(PutEmail.class);
        this.delete(AccountResource.EMAIL_KIND).to(DeleteEmail.class);
        this.put(AccountResource.EMAIL_KIND, "preferred").to(PutPreferred.class);
        this.get(AccountResource.ACCOUNT_KIND, "password.http").to(GetHttpPassword.class);
        this.put(AccountResource.ACCOUNT_KIND, "password.http").to(PutHttpPassword.class);
        this.delete(AccountResource.ACCOUNT_KIND, "password.http").to(PutHttpPassword.class);
        this.child(AccountResource.ACCOUNT_KIND, "sshkeys").to(SshKeys.class);
        this.post(AccountResource.ACCOUNT_KIND, "sshkeys").to(AddSshKey.class);
        this.get(AccountResource.SSH_KEY_KIND).to(GetSshKey.class);
        this.delete(AccountResource.SSH_KEY_KIND).to(DeleteSshKey.class);
        this.get(AccountResource.ACCOUNT_KIND, "avatar").to(GetAvatar.class);
        this.get(AccountResource.ACCOUNT_KIND, "avatar.change.url").to(GetAvatarChangeUrl.class);
        this.child(AccountResource.ACCOUNT_KIND, "capabilities").to(Capabilities.class);
        this.get(AccountResource.ACCOUNT_KIND, "groups").to(GetGroups.class);
        this.get(AccountResource.ACCOUNT_KIND, "preferences").to(GetPreferences.class);
        this.post(AccountResource.ACCOUNT_KIND, "preferences").to(SetPreferences.class);
        this.get(AccountResource.ACCOUNT_KIND, "preferences.diff").to(GetDiffPreferences.class);
        this.put(AccountResource.ACCOUNT_KIND, "preferences.diff").to(SetDiffPreferences.class);
        this.get(AccountResource.CAPABILITY_KIND).to(GetCapabilities.CheckOne.class);
        this.child(AccountResource.ACCOUNT_KIND, "starred.changes").to(StarredChanges.class);
        this.put(AccountResource.STARRED_CHANGE_KIND).to(StarredChanges.Put.class);
        this.delete(AccountResource.STARRED_CHANGE_KIND).to(StarredChanges.Delete.class);
        this.bind(StarredChanges.Create.class);
        this.install(new FactoryModuleBuilder().build(CreateAccount.Factory.class));
        this.install(new FactoryModuleBuilder().build(CreateEmail.Factory.class));
    }
}

