/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.common.ListChangesOption;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.changedetail.RebaseChange;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Rebase
implements RestModifyView<RevisionResource, Input>,
UiAction<RevisionResource> {
    private final Provider<RebaseChange> rebaseChange;
    private final ChangeJson json;

    @Inject
    public Rebase(Provider<RebaseChange> rebaseChange, ChangeJson json) {
        this.rebaseChange = rebaseChange;
        this.json = json.addOption(ListChangesOption.CURRENT_REVISION).addOption(ListChangesOption.CURRENT_COMMIT);
    }

    public ChangeJson.ChangeInfo apply(RevisionResource rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, EmailException, OrmException {
        ChangeControl control = rsrc.getControl();
        Change change = rsrc.getChange();
        if (!control.canRebase()) {
            throw new AuthException("rebase not permitted");
        }
        if (!change.getStatus().isOpen()) {
            throw new ResourceConflictException("change is " + change.getStatus().name().toLowerCase());
        }
        try {
            this.rebaseChange.get().rebase(rsrc.getChange(), rsrc.getPatchSet().getId(), rsrc.getUser());
        }
        catch (InvalidChangeOperationException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        catch (IOException e) {
            throw new ResourceConflictException(e.getMessage());
        }
        catch (NoSuchChangeException e) {
            throw new ResourceNotFoundException(change.getId().toString());
        }
        return this.json.format(change.getId());
    }

    @Override
    public UiAction.Description getDescription(RevisionResource resource) {
        return new UiAction.Description().setLabel("Rebase").setTitle("Rebase onto tip of branch or parent change").setVisible(resource.getChange().getStatus().isOpen() && resource.getControl().canRebase() && this.rebaseChange.get().canRebase(resource));
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, Input> {
        private final Provider<ReviewDb> dbProvider;
        private final Rebase rebase;

        @Inject
        CurrentRevision(Provider<ReviewDb> dbProvider, Rebase rebase) {
            this.dbProvider = dbProvider;
            this.rebase = rebase;
        }

        public ChangeJson.ChangeInfo apply(ChangeResource rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, EmailException, OrmException {
            PatchSet ps = this.dbProvider.get().patchSets().get(rsrc.getChange().currentPatchSetId());
            if (ps == null) {
                throw new ResourceConflictException("current revision is missing");
            }
            if (!rsrc.getControl().isPatchVisible(ps, this.dbProvider.get())) {
                throw new AuthException("current revision not accessible");
            }
            return this.rebase.apply(new RevisionResource(rsrc, ps), input);
        }
    }

    public static class Input {
    }
}

