/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TagMatcher;
import com.google.gerrit.server.git.TagSet;
import java.util.Collection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

class TagSetHolder {
    private final Object buildLock = new Object();
    private final Project.NameKey projectName;
    private volatile TagSet tags;

    TagSetHolder(Project.NameKey projectName) {
        this.projectName = projectName;
    }

    Project.NameKey getProjectName() {
        return this.projectName;
    }

    TagSet getTagSet() {
        return this.tags;
    }

    void setTagSet(TagSet tags) {
        this.tags = tags;
    }

    TagMatcher matcher(TagCache cache, Repository db, Collection<Ref> include) {
        TagSet tags = this.tags;
        if (tags == null) {
            tags = this.build(cache, db);
        }
        TagMatcher m = new TagMatcher(this, cache, db, include, tags, false);
        tags.prepare(m);
        if (!m.newRefs.isEmpty() || !m.lostRefs.isEmpty()) {
            tags = this.rebuild(cache, db, tags, m);
            m = new TagMatcher(this, cache, db, include, tags, true);
            tags.prepare(m);
        }
        return m;
    }

    void rebuildForNewTags(TagCache cache, TagMatcher m) {
        m.tags = this.rebuild(cache, m.db, m.tags, null);
        m.mask.clear();
        m.newRefs.clear();
        m.lostRefs.clear();
        m.tags.prepare(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagSet build(TagCache cache, Repository db) {
        Object object = this.buildLock;
        synchronized (object) {
            TagSet tags = this.tags;
            if (tags == null) {
                tags = new TagSet(this.projectName);
                tags.build(db, null, null);
                this.tags = tags;
                cache.put(this.projectName, this);
            }
            return tags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagSet rebuild(TagCache cache, Repository db, TagSet old, TagMatcher m) {
        Object object = this.buildLock;
        synchronized (object) {
            TagSet cur = this.tags;
            if (cur == old) {
                cur = new TagSet(this.projectName);
                cur.build(db, old, m);
                this.tags = cur;
                cache.put(this.projectName, this);
            }
            return cur;
        }
    }
}

