/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.CreateGroup;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.ListGroups;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class GroupsCollection
implements RestCollection<TopLevelResource, GroupResource>,
AcceptsCreate<TopLevelResource> {
    private final DynamicMap<RestView<GroupResource>> views;
    private final Provider<ListGroups> list;
    private final CreateGroup.Factory createGroup;
    private final GroupControl.Factory groupControlFactory;
    private final GroupBackend groupBackend;
    private final Provider<CurrentUser> self;

    @Inject
    GroupsCollection(DynamicMap<RestView<GroupResource>> views, Provider<ListGroups> list, CreateGroup.Factory createGroup, GroupControl.Factory groupControlFactory, GroupBackend groupBackend, Provider<CurrentUser> self) {
        this.views = views;
        this.list = list;
        this.createGroup = createGroup;
        this.groupControlFactory = groupControlFactory;
        this.groupBackend = groupBackend;
        this.self = self;
    }

    @Override
    public RestView<TopLevelResource> list() throws ResourceNotFoundException, AuthException {
        CurrentUser user = this.self.get();
        if (user instanceof AnonymousUser) {
            throw new AuthException("Authentication required");
        }
        if (!user.isIdentifiedUser()) {
            throw new ResourceNotFoundException();
        }
        return this.list.get();
    }

    @Override
    public GroupResource parse(TopLevelResource parent, IdString id) throws AuthException, ResourceNotFoundException {
        CurrentUser user = this.self.get();
        if (user instanceof AnonymousUser) {
            throw new AuthException("Authentication required");
        }
        if (!user.isIdentifiedUser()) {
            throw new ResourceNotFoundException(id);
        }
        GroupDescription.Basic group = this.parseId(id.get());
        if (group == null) {
            throw new ResourceNotFoundException(id.get());
        }
        GroupControl ctl = this.groupControlFactory.controlFor(group);
        if (!ctl.isVisible()) {
            throw new ResourceNotFoundException(id);
        }
        return new GroupResource(ctl);
    }

    public GroupDescription.Basic parse(String id) throws UnprocessableEntityException {
        GroupDescription.Basic group = this.parseId(id);
        if (group == null || !this.groupControlFactory.controlFor(group).isVisible()) {
            throw new UnprocessableEntityException(String.format("Group Not Found: %s", id));
        }
        return group;
    }

    public GroupDescription.Basic parseInternal(String id) throws UnprocessableEntityException {
        GroupDescription.Basic group = this.parse(id);
        if (GroupDescriptions.toAccountGroup(group) == null) {
            throw new UnprocessableEntityException(String.format("External Group Not Allowed: %s", id));
        }
        return group;
    }

    public GroupDescription.Basic parseId(String id) {
        GroupDescription.Basic d;
        GroupReference ref;
        GroupDescription.Basic d2;
        AccountGroup.UUID uuid = new AccountGroup.UUID(id);
        if (this.groupBackend.handles(uuid) && (d2 = this.groupBackend.get(uuid)) != null) {
            return d2;
        }
        if (id.matches("^[1-9][0-9]*$")) {
            try {
                AccountGroup.Id legacyId = AccountGroup.Id.parse(id);
                return this.groupControlFactory.controlFor(legacyId).getGroup();
            }
            catch (IllegalArgumentException invalidId) {
            }
            catch (NoSuchGroupException e) {
                // empty catch block
            }
        }
        if ((ref = GroupBackends.findExactSuggestion(this.groupBackend, id)) != null && (d = this.groupBackend.get(ref.getUUID())) != null) {
            return d;
        }
        return null;
    }

    public CreateGroup create(TopLevelResource root, IdString name) {
        return this.createGroup.create(name.get());
    }

    @Override
    public DynamicMap<RestView<GroupResource>> views() {
        return this.views;
    }
}

