/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.ioutil;

import com.google.gerrit.reviewdb.client.CodedEnum;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.util.IO;

public class BasicSerialization {
    private static final byte[] NO_BYTES = new byte[0];

    private static int safeRead(InputStream input) throws IOException {
        int b = input.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b;
    }

    public static long readFixInt64(InputStream input) throws IOException {
        long h = BasicSerialization.readFixInt32(input);
        long l = (long)BasicSerialization.readFixInt32(input) & 0xFFFFFFFFL;
        return h << 32 | l;
    }

    public static void writeFixInt64(OutputStream output, long val) throws IOException {
        BasicSerialization.writeFixInt32(output, (int)(val >>> 32));
        BasicSerialization.writeFixInt32(output, (int)(val & 0xFFFFFFFFL));
    }

    public static int readFixInt32(InputStream input) throws IOException {
        int b1 = BasicSerialization.safeRead(input);
        int b2 = BasicSerialization.safeRead(input);
        int b3 = BasicSerialization.safeRead(input);
        int b4 = BasicSerialization.safeRead(input);
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public static void writeFixInt32(OutputStream output, int val) throws IOException {
        output.write(val >>> 24 & 0xFF);
        output.write(val >>> 16 & 0xFF);
        output.write(val >>> 8 & 0xFF);
        output.write(val & 0xFF);
    }

    public static int readVarInt32(InputStream input) throws IOException {
        int result = 0;
        for (int offset = 0; offset < 32; offset += 7) {
            int b = BasicSerialization.safeRead(input);
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new EOFException();
    }

    public static void writeVarInt32(OutputStream output, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                output.write(value);
                return;
            }
            output.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        int len = BasicSerialization.readVarInt32(input);
        if (len == 0) {
            return NO_BYTES;
        }
        byte[] buf = new byte[len];
        IO.readFully(input, buf, 0, len);
        return buf;
    }

    public static void writeBytes(OutputStream output, byte[] data) throws IOException {
        BasicSerialization.writeBytes(output, data, 0, data.length);
    }

    public static void writeBytes(OutputStream output, byte[] data, int offset, int len) throws IOException {
        BasicSerialization.writeVarInt32(output, len);
        output.write(data, offset, len);
    }

    public static String readString(InputStream input) throws IOException {
        byte[] bin = BasicSerialization.readBytes(input);
        if (bin.length == 0) {
            return null;
        }
        return new String(bin, 0, bin.length, "UTF-8");
    }

    public static void writeString(OutputStream output, String s) throws IOException {
        if (s == null) {
            BasicSerialization.writeVarInt32(output, 0);
        } else {
            BasicSerialization.writeBytes(output, s.getBytes("UTF-8"));
        }
    }

    public static <T extends CodedEnum> T readEnum(InputStream input, T[] all) throws IOException {
        int val = BasicSerialization.readVarInt32(input);
        for (T t : all) {
            if (t.getCode() != val) continue;
            return t;
        }
        throw new IOException("Invalid enum " + val + " for " + all[0].getClass());
    }

    public static <T extends CodedEnum> void writeEnum(OutputStream output, T e) throws IOException {
        BasicSerialization.writeVarInt32(output, e.getCode());
    }

    private BasicSerialization() {
    }
}

