/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.server.config.SitePaths;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.Properties;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityRuntimeProvider
implements Provider<RuntimeInstance> {
    private final SitePaths site;

    @Inject
    VelocityRuntimeProvider(SitePaths site) {
        this.site = site;
    }

    @Override
    public RuntimeInstance get() {
        String rl = "resource.loader";
        String pkg = "org.apache.velocity.runtime.resource.loader";
        Properties p = new Properties();
        p.setProperty("velocimacro.permissions.allow.inline.local.scope", "true");
        p.setProperty("runtime.log.logsystem.class", Slf4jLogChute.class.getName());
        p.setProperty("runtime.references.strict", "true");
        p.setProperty("runtime.log.logsystem.log4j.category", "velocity");
        if (this.site.mail_dir.isDirectory()) {
            p.setProperty(rl, "file, class");
            p.setProperty("file." + rl + ".class", pkg + ".FileResourceLoader");
            p.setProperty("file." + rl + ".path", this.site.mail_dir.getAbsolutePath());
            p.setProperty("class." + rl + ".class", pkg + ".ClasspathResourceLoader");
        } else {
            p.setProperty(rl, "class");
            p.setProperty("class." + rl + ".class", pkg + ".ClasspathResourceLoader");
        }
        RuntimeInstance ri = new RuntimeInstance();
        try {
            ri.init(p);
        }
        catch (Exception err) {
            throw new ProvisionException("Cannot configure Velocity templates", err);
        }
        return ri;
    }

    public static class Slf4jLogChute
    implements LogChute {
        private static final Logger log = LoggerFactory.getLogger("velocity");

        @Override
        public void init(RuntimeServices rs) {
        }

        @Override
        public boolean isLevelEnabled(int level) {
            switch (level) {
                default: {
                    return log.isDebugEnabled();
                }
                case 1: {
                    return log.isInfoEnabled();
                }
                case 2: {
                    return log.isWarnEnabled();
                }
                case 3: 
            }
            return log.isErrorEnabled();
        }

        @Override
        public void log(int level, String message) {
            this.log(level, message, null);
        }

        @Override
        public void log(int level, String msg, Throwable err) {
            switch (level) {
                default: {
                    log.debug(msg, err);
                    break;
                }
                case 1: {
                    log.info(msg, err);
                    break;
                }
                case 2: {
                    log.warn(msg, err);
                    break;
                }
                case 3: {
                    log.error(msg, err);
                }
            }
        }
    }
}

