/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.GerritPersonIdentProvider;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.PersonIdent;

@Singleton
class CopyConfigModule
extends AbstractModule {
    @Inject
    @SitePath
    private File sitePath;
    @Inject
    private SitePaths sitePaths;
    @Inject
    private TrackingFooters trackingFooters;
    @Inject
    @GerritServerConfig
    private Config gerritServerConfig;
    @Inject
    private SchemaFactory<ReviewDb> schemaFactory;
    @Inject
    private GitRepositoryManager gitRepositoryManager;
    @Inject
    @AnonymousCowardName
    private String anonymousCowardName;
    @Inject
    private GerritPersonIdentProvider serverIdentProvider;

    @Provides
    @SitePath
    File getSitePath() {
        return this.sitePath;
    }

    @Provides
    SitePaths getSitePaths() {
        return this.sitePaths;
    }

    @Provides
    TrackingFooters getTrackingFooters() {
        return this.trackingFooters;
    }

    @Provides
    @GerritServerConfig
    Config getGerritServerConfig() {
        return this.gerritServerConfig;
    }

    @Provides
    SchemaFactory<ReviewDb> getSchemaFactory() {
        return this.schemaFactory;
    }

    @Provides
    GitRepositoryManager getGitRepositoryManager() {
        return this.gitRepositoryManager;
    }

    @Provides
    @AnonymousCowardName
    String getAnonymousCowardName() {
        return this.anonymousCowardName;
    }

    @Provides
    @GerritPersonIdent
    PersonIdent getServerIdent() {
        return this.serverIdentProvider.get();
    }

    @Inject
    CopyConfigModule() {
    }

    @Override
    protected void configure() {
    }
}

