/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.common.GitPerson;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.project.CommitResource;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class GetCommit
implements RestReadView<CommitResource> {
    public CommitInfo apply(CommitResource rsrc) {
        RevCommit c = rsrc.getCommit();
        CommitInfo info = GetCommit.toCommitInfo(c);
        return info;
    }

    private static CommitInfo toCommitInfo(RevCommit commit) {
        CommitInfo info = new CommitInfo();
        info.commit = commit.getName();
        info.author = GetCommit.toGitPerson(commit.getAuthorIdent());
        info.committer = GetCommit.toGitPerson(commit.getCommitterIdent());
        info.subject = commit.getShortMessage();
        info.message = commit.getFullMessage();
        info.parents = new ArrayList<CommitInfo>(commit.getParentCount());
        for (int i = 0; i < commit.getParentCount(); ++i) {
            RevCommit p = commit.getParent(i);
            CommitInfo parentInfo = new CommitInfo();
            parentInfo.commit = p.getName();
            parentInfo.subject = p.getShortMessage();
            info.parents.add(parentInfo);
        }
        return info;
    }

    private static GitPerson toGitPerson(PersonIdent ident) {
        GitPerson gp = new GitPerson();
        gp.name = ident.getName();
        gp.email = ident.getEmailAddress();
        gp.date = new Timestamp(ident.getWhen().getTime());
        gp.tz = ident.getTimeZoneOffset();
        return gp;
    }
}

