/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllProjectsNameProvider;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class ProjectJson {
    private final AllProjectsName allProjects;
    private final Provider<WebLinks> webLinks;

    @Inject
    ProjectJson(AllProjectsNameProvider allProjectsNameProvider, Provider<WebLinks> webLinks) {
        this.allProjects = allProjectsNameProvider.get();
        this.webLinks = webLinks;
    }

    public ProjectInfo format(ProjectResource rsrc) {
        return this.format(rsrc.getControl().getProject());
    }

    public ProjectInfo format(Project p) {
        ProjectInfo info = new ProjectInfo();
        info.name = p.getName();
        Project.NameKey parentName = p.getParent(this.allProjects);
        info.parent = parentName != null ? parentName.get() : null;
        info.description = Strings.emptyToNull(p.getDescription());
        info.state = p.getState();
        info.id = Url.encode(info.name);
        info.webLinks = Lists.newArrayList();
        for (WebLinkInfo link : this.webLinks.get().getProjectLinks(p.getName())) {
            if (Strings.isNullOrEmpty(link.name) || Strings.isNullOrEmpty(link.url)) continue;
            info.webLinks.add(link);
        }
        return info;
    }
}

