/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RuleEvalException;
import com.google.gerrit.server.query.change.ChangeData;
import com.googlecode.prolog_cafe.compiler.CompileException;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SubmitRuleEvaluator {
    private final ReviewDb db;
    private final PatchSet patchSet;
    private final ProjectControl projectControl;
    private final ChangeControl changeControl;
    private final Change change;
    private final ChangeData cd;
    private final boolean fastEvalLabels;
    private final String userRuleLocatorName;
    private final String userRuleWrapperName;
    private final String filterRuleLocatorName;
    private final String filterRuleWrapperName;
    private final boolean skipFilters;
    private final InputStream rulesInputStream;
    private Term submitRule;
    private String projectName;

    public SubmitRuleEvaluator(ReviewDb db, PatchSet patchSet, ProjectControl projectControl, ChangeControl changeControl, Change change, ChangeData cd, boolean fastEvalLabels, String userRuleLocatorName, String userRuleWrapperName, String filterRuleLocatorName, String filterRuleWrapperName) {
        this(db, patchSet, projectControl, changeControl, change, cd, fastEvalLabels, userRuleLocatorName, userRuleWrapperName, filterRuleLocatorName, filterRuleWrapperName, false, null);
    }

    public SubmitRuleEvaluator(ReviewDb db, PatchSet patchSet, ProjectControl projectControl, ChangeControl changeControl, Change change, ChangeData cd, boolean fastEvalLabels, String userRuleLocatorName, String userRuleWrapperName, String filterRuleLocatorName, String filterRuleWrapperName, boolean skipSubmitFilters, InputStream rules) {
        this.db = db;
        this.patchSet = patchSet;
        this.projectControl = projectControl;
        this.changeControl = changeControl;
        this.change = change;
        this.cd = Preconditions.checkNotNull(cd, "ChangeData");
        this.fastEvalLabels = fastEvalLabels;
        this.userRuleLocatorName = userRuleLocatorName;
        this.userRuleWrapperName = userRuleWrapperName;
        this.filterRuleLocatorName = filterRuleLocatorName;
        this.filterRuleWrapperName = filterRuleWrapperName;
        this.skipFilters = skipSubmitFilters;
        this.rulesInputStream = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Term> evaluate() throws RuleEvalException {
        try (PrologEnvironment env = this.getPrologEnvironment();){
            this.submitRule = env.once("gerrit", this.userRuleLocatorName, (Term)new VariableTerm());
            if (this.fastEvalLabels) {
                env.once("gerrit", "assume_range_from_label", new Term[0]);
            }
            ArrayList<Term> results = new ArrayList<Term>();
            try {
                for (Term[] template : env.all("gerrit", this.userRuleWrapperName, this.submitRule, new VariableTerm())) {
                    results.add(template[1]);
                }
            }
            catch (PrologException err) {
                throw new RuleEvalException("Exception calling " + this.submitRule + " on change " + this.change.getId() + " of " + this.getProjectName(), err);
            }
            catch (RuntimeException err) {
                throw new RuleEvalException("Exception calling " + this.submitRule + " on change " + this.change.getId() + " of " + this.getProjectName(), err);
            }
            Term resultsTerm = SubmitRuleEvaluator.toListTerm(results);
            if (!this.skipFilters) {
                resultsTerm = this.runSubmitFilters(resultsTerm, env);
            }
            if (resultsTerm.isList()) {
                ArrayList<Term> r = Lists.newArrayList();
                Term t = resultsTerm;
                while (t.isList()) {
                    ListTerm l = (ListTerm)t;
                    r.add(l.car().dereference());
                    t = l.cdr().dereference();
                }
                ArrayList<Term> arrayList = r;
                return arrayList;
            }
            List<Term> list = Collections.emptyList();
            return list;
        }
    }

    private PrologEnvironment getPrologEnvironment() throws RuleEvalException {
        PrologEnvironment env;
        ProjectState projectState = this.projectControl.getProjectState();
        try {
            env = this.rulesInputStream == null ? projectState.newPrologEnvironment() : projectState.newPrologEnvironment("stdin", this.rulesInputStream);
        }
        catch (CompileException err) {
            throw new RuleEvalException("Cannot consult rules.pl for " + this.getProjectName(), err);
        }
        env.set(StoredValues.REVIEW_DB, this.db);
        env.set(StoredValues.CHANGE_DATA, this.cd);
        env.set(StoredValues.PATCH_SET, this.patchSet);
        env.set(StoredValues.CHANGE_CONTROL, this.changeControl);
        return env;
    }

    private Term runSubmitFilters(Term results, PrologEnvironment env) throws RuleEvalException {
        ProjectState projectState = this.projectControl.getProjectState();
        PrologEnvironment childEnv = env;
        for (ProjectState parentState : projectState.parents()) {
            PrologEnvironment parentEnv;
            try {
                parentEnv = parentState.newPrologEnvironment();
            }
            catch (CompileException err) {
                throw new RuleEvalException("Cannot consult rules.pl for " + parentState.getProject().getName(), err);
            }
            parentEnv.copyStoredValues(childEnv);
            Term filterRule = parentEnv.once("gerrit", this.filterRuleLocatorName, (Term)new VariableTerm());
            try {
                if (this.fastEvalLabels) {
                    env.once("gerrit", "assume_range_from_label", new Term[0]);
                }
                Term[] template = parentEnv.once("gerrit", this.filterRuleWrapperName, filterRule, results, new VariableTerm());
                results = template[2];
            }
            catch (PrologException err) {
                throw new RuleEvalException("Exception calling " + filterRule + " on change " + this.change.getId() + " of " + parentState.getProject().getName(), err);
            }
            catch (RuntimeException err) {
                throw new RuleEvalException("Exception calling " + filterRule + " on change " + this.change.getId() + " of " + parentState.getProject().getName(), err);
            }
            childEnv = parentEnv;
        }
        return results;
    }

    private static Term toListTerm(List<Term> terms) {
        Term list = Prolog.Nil;
        for (int i = terms.size() - 1; i >= 0; --i) {
            list = new ListTerm(terms.get(i), list);
        }
        return list;
    }

    public Term getSubmitRule() {
        return this.submitRule;
    }

    private String getProjectName() {
        if (this.projectName == null) {
            this.projectName = this.projectControl.getProjectState().getProject().getName();
        }
        return this.projectName;
    }
}

