/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.server.query.OperatorPredicate;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gerrit.server.query.change.ChangeQueryBuilder;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;

class HasDraftByPredicate
extends OperatorPredicate<ChangeData>
implements ChangeDataSource {
    private final ChangeQueryBuilder.Arguments args;
    private final Account.Id accountId;

    HasDraftByPredicate(ChangeQueryBuilder.Arguments args, Account.Id accountId) {
        super("draftby", accountId.toString());
        this.args = args;
        this.accountId = accountId;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        for (PatchLineComment c : object.comments()) {
            if (c.getStatus() != PatchLineComment.Status.DRAFT || !c.getAuthor().equals(this.accountId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResultSet<ChangeData> read() throws OrmException {
        HashSet<Change.Id> ids = new HashSet<Change.Id>();
        for (PatchLineComment sc : this.args.db.get().patchComments().draftByAuthor(this.accountId)) {
            ids.add(sc.getKey().getParentKey().getParentKey().getParentKey());
        }
        ArrayList<ChangeData> r = new ArrayList<ChangeData>(ids.size());
        for (Change.Id id : ids) {
            r.add(this.args.changeDataFactory.create(this.args.db.get(), id));
        }
        return new ListResultSet<ChangeData>(r);
    }

    @Override
    public boolean hasChange() {
        return false;
    }

    @Override
    public int getCardinality() {
        return 20;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

