/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlStringTypeInfo;
import com.google.gwtorm.schema.sql.SqlTimestampTypeInfo;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;

public class DialectMySQL
extends SqlDialect {
    public DialectMySQL() {
        this.types.put(String.class, new SqlStringTypeInfo(){

            @Override
            public String getSqlType(ColumnModel col, SqlDialect dialect) {
                Column column = col.getColumnAnnotation();
                StringBuilder r = new StringBuilder();
                if (column.length() <= 0) {
                    r.append("VARCHAR(255) BINARY");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else if (column.length() <= 255) {
                    r.append("VARCHAR(" + column.length() + ") BINARY");
                    if (col.isNotNull()) {
                        r.append(" DEFAULT ''");
                    }
                } else {
                    r.append(dialect.getSqlTypeName(-1));
                }
                if (col.isNotNull()) {
                    r.append(" NOT NULL");
                }
                return r.toString();
            }
        });
        this.types.put(Timestamp.class, new SqlTimestampTypeInfo(){

            @Override
            public String getSqlType(ColumnModel col, SqlDialect dialect) {
                StringBuilder r = new StringBuilder();
                r.append(dialect.getSqlTypeName(this.getSqlTypeConstant()));
                if (col.isNotNull()) {
                    r.append(" NOT NULL");
                } else {
                    r.append(" NULL DEFAULT NULL");
                }
                return r.toString();
            }
        });
    }

    @Override
    public boolean handles(String url, Connection c) {
        return url.startsWith("jdbc:mysql:");
    }

    @Override
    public String getCreateSequenceSql(SequenceModel seq) {
        StringBuilder r = new StringBuilder();
        r.append("CREATE TABLE ");
        r.append(seq.getSequenceName());
        r.append("(s SERIAL)");
        return r.toString();
    }

    @Override
    public String getDropSequenceSql(String name) {
        return "DROP TABLE " + name;
    }

    @Override
    protected String getNextSequenceValueSql(String seqname) {
        return seqname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong(Connection conn, String seqname) throws OrmException {
        long l;
        Statement st = conn.createStatement();
        try {
            long r;
            st.execute("INSERT INTO " + seqname + "(s)VALUES(NULL)", 1);
            try (ResultSet rs = st.getGeneratedKeys();){
                if (!rs.next()) {
                    throw new SQLException("No result row for sequence query");
                }
                r = rs.getLong(1);
            }
            l = r;
        }
        catch (Throwable throwable) {
            try {
                st.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw this.convertError("sequence", seqname, e);
            }
        }
        st.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listTables(Connection db) throws SQLException {
        String[] types = new String[]{"TABLE"};
        try (ResultSet rs = db.getMetaData().getTables(null, null, null, types);){
            HashSet<String> tables = new HashSet<String>();
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (this.isSequence(db, name)) continue;
                tables.add(name.toLowerCase());
            }
            HashSet<String> hashSet = tables;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection db) throws SQLException {
        String[] types = new String[]{"TABLE"};
        try (ResultSet rs = db.getMetaData().getTables(null, null, null, types);){
            HashSet<String> sequences = new HashSet<String>();
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (!this.isSequence(db, name)) continue;
                sequences.add(name.toLowerCase());
            }
            HashSet<String> hashSet = sequences;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSequence(Connection db, String tableName) throws SQLException {
        DatabaseMetaData meta = db.getMetaData();
        if (meta.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (meta.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        try (ResultSet rs = meta.getColumns(null, null, tableName, null);){
            int cnt = 0;
            boolean serial = false;
            while (rs.next()) {
                ++cnt;
                if (rs.getInt("DATA_TYPE") != -5 || !"YES".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                serial = true;
            }
            boolean bl = cnt == 1 && serial;
            return bl;
        }
    }

    @Override
    public void renameTable(StatementExecutor e, String from, String to) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("RENAME TABLE ");
        r.append(from);
        r.append(" TO ");
        r.append(to);
        r.append(" ");
        e.execute(r.toString());
    }

    @Override
    public void renameColumn(StatementExecutor stmt, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuffer r = new StringBuffer();
        r.append("ALTER TABLE ");
        r.append(tableName);
        r.append(" CHANGE ");
        r.append(fromColumn);
        r.append(" ");
        r.append(col.getColumnName());
        r.append(" ");
        r.append(this.getSqlTypeInfo(col).getSqlType(col, this));
        stmt.execute(r.toString());
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        switch (err.getErrorCode()) {
            case 1022: 
            case 1062: 
            case 1169: {
                return new OrmDuplicateKeyException(entity, err);
            }
        }
        return super.convertError(op, entity, err);
    }
}

