/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.unix;

import java.io.File;
import java.io.IOException;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.agent.unix.AgentForwardedChannel;
import org.apache.sshd.agent.unix.AprLibrary;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.OsUtils;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentServerProxy
implements SshAgentServer {
    private static final Logger LOG = LoggerFactory.getLogger(AgentServerProxy.class);
    private final ConnectionService service;
    private final String authSocket;
    private final long pool;
    private final long handle;
    private final Thread thread;
    private volatile boolean closed;
    private volatile boolean innerFinished;
    private static final byte[] END_OF_STREAM_MESSAGE = new byte[]{"END_OF_STREAM".getBytes()[0]};

    public AgentServerProxy(ConnectionService service) throws IOException {
        this.service = service;
        try {
            String authSocket = AprLibrary.createLocalSocketAddress();
            this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
            this.handle = Local.create((String)authSocket, (long)this.pool);
            this.authSocket = authSocket;
            int result = Local.bind((long)this.handle, (long)0L);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            AprLibrary.secureLocalSocket(authSocket, this.handle);
            result = Local.listen((long)this.handle, (int)0);
            if (result != 0) {
                AgentServerProxy.throwException(result);
            }
            this.thread = new Thread("sshd-AgentServerProxy-PIPE-" + authSocket){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        while (!AgentServerProxy.this.closed) {
                            try {
                                long clientSock = Local.accept((long)AgentServerProxy.this.handle);
                                if (!AgentServerProxy.this.closed) {
                                    Socket.timeoutSet((long)clientSock, (long)10000000L);
                                    AgentForwardedChannel channel = new AgentForwardedChannel(clientSock);
                                    AgentServerProxy.this.service.registerChannel(channel);
                                    OpenFuture future = (OpenFuture)channel.open().await();
                                    Throwable t = future.getException();
                                    if (t instanceof Exception) {
                                        throw (Exception)t;
                                    }
                                    if (t == null) continue;
                                    throw new Exception(t);
                                }
                                break;
                            }
                            catch (Exception e) {
                                if (AgentServerProxy.this.closed) continue;
                                LOG.info("Exchange caught in authentication forwarding", e);
                            }
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        AgentServerProxy.this.innerFinished = true;
                        throw throwable;
                    }
                    AgentServerProxy.this.innerFinished = true;
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    public String getId() {
        return this.authSocket;
    }

    public synchronized void close() {
        block14: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            boolean isDebug = LOG.isDebugEnabled();
            if (this.handle != 0L) {
                int closeCode;
                block13: {
                    if (!this.innerFinished) {
                        try {
                            int sendResult;
                            long tmpPool = Pool.create((long)AprLibrary.getInstance().getRootPool());
                            long tmpSocket = Local.create((String)this.authSocket, (long)tmpPool);
                            long connectResult = Local.connect((long)tmpSocket, (long)0L);
                            if (connectResult != 0L && isDebug) {
                                LOG.debug("Unable to connect to socket PIPE {}. APR errcode {}", (Object)this.authSocket, (Object)connectResult);
                            }
                            if ((sendResult = Socket.send((long)tmpSocket, (byte[])END_OF_STREAM_MESSAGE, (int)0, (int)1)) != 1 && isDebug) {
                                LOG.debug("Unable to send signal the EOS for {}. APR retcode {} != 1", (Object)this.authSocket, (Object)sendResult);
                            }
                        }
                        catch (Exception e) {
                            if (!isDebug) break block13;
                            LOG.debug("Exception connecting to the PIPE socket: " + this.authSocket, e);
                        }
                    }
                }
                if ((closeCode = Socket.close((long)this.handle)) != 0) {
                    LOG.warn("Exceptions closing the PIPE: {}. APR error code: {} ", (Object)this.authSocket, (Object)closeCode);
                }
            }
            try {
                File socketFile;
                if (this.authSocket != null && (socketFile = new File(this.authSocket)).exists()) {
                    File parentFile;
                    if (socketFile.delete() && isDebug) {
                        LOG.debug("Deleted PIPE socket {}", (Object)socketFile);
                    }
                    if (OsUtils.isUNIX() && (parentFile = socketFile.getParentFile()).delete() && isDebug) {
                        LOG.debug("Deleted parent PIPE socket {}", (Object)parentFile);
                    }
                }
            }
            catch (Exception e) {
                if (!isDebug) break block14;
                LOG.debug("Exception deleting the PIPE socket: " + this.authSocket, e);
            }
        }
    }

    static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }
}

