/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api.errors;

import java.text.MessageFormat;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;

public class ConcurrentRefUpdateException
extends GitAPIException {
    private static final long serialVersionUID = 1L;
    private RefUpdate.Result rc;
    private Ref ref;

    public ConcurrentRefUpdateException(String message, Ref ref, RefUpdate.Result rc, Throwable cause) {
        String string;
        if (rc == null) {
            string = message;
        } else {
            String string2 = String.valueOf(String.valueOf(message));
            String string3 = String.valueOf(String.valueOf(MessageFormat.format(JGitText.get().refUpdateReturnCodeWas, new Object[]{rc})));
            string = new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(". ").append(string3).toString();
        }
        super(string, cause);
        this.rc = rc;
        this.ref = ref;
    }

    public ConcurrentRefUpdateException(String message, Ref ref, RefUpdate.Result rc) {
        String string;
        if (rc == null) {
            string = message;
        } else {
            String string2 = String.valueOf(String.valueOf(message));
            String string3 = String.valueOf(String.valueOf(MessageFormat.format(JGitText.get().refUpdateReturnCodeWas, new Object[]{rc})));
            string = new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(". ").append(string3).toString();
        }
        super(string);
        this.rc = rc;
        this.ref = ref;
    }

    public Ref getRef() {
        return this.ref;
    }

    public RefUpdate.Result getResult() {
        return this.rc;
    }
}

