/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.resolver.AsIsFileService;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class AsIsFileFilter
implements Filter {
    private final AsIsFileService asIs;

    AsIsFileFilter(AsIsFileService getAnyFile) {
        this.asIs = getAnyFile;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            Repository db = ServletUtils.getRepository(request);
            this.asIs.access((HttpServletRequest)request, db);
            chain.doFilter(request, response);
        }
        catch (ServiceNotAuthorizedException e) {
            ((HttpServletResponse)response).sendError(401);
        }
        catch (ServiceNotEnabledException e) {
            ((HttpServletResponse)response).sendError(403);
        }
    }
}

