/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.TrackingRefUpdate;

public class RemoteRefUpdate {
    private final ObjectId expectedOldObjectId;
    private final ObjectId newObjectId;
    private final String remoteName;
    private final TrackingRefUpdate trackingRefUpdate;
    private final String srcRef;
    private final boolean forceUpdate;
    private Status status;
    private boolean fastForward;
    private String message;
    private final Repository localDb;
    private RefUpdate localUpdate;

    public RemoteRefUpdate(Repository localDb, String srcRef, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        this(localDb, srcRef, srcRef != null ? localDb.resolve(srcRef) : ObjectId.zeroId(), remoteName, forceUpdate, localName, expectedOldObjectId);
    }

    public RemoteRefUpdate(Repository localDb, Ref srcRef, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        this(localDb, srcRef != null ? srcRef.getName() : null, srcRef != null ? srcRef.getObjectId() : null, remoteName, forceUpdate, localName, expectedOldObjectId);
    }

    public RemoteRefUpdate(Repository localDb, String srcRef, ObjectId srcId, String remoteName, boolean forceUpdate, String localName, ObjectId expectedOldObjectId) throws IOException {
        if (remoteName == null) {
            throw new IllegalArgumentException(JGitText.get().remoteNameCantBeNull);
        }
        if (srcId == null && srcRef != null) {
            throw new IOException(MessageFormat.format(JGitText.get().sourceRefDoesntResolveToAnyObject, srcRef));
        }
        this.srcRef = srcRef != null ? srcRef : (srcId != null && !srcId.equals(ObjectId.zeroId()) ? srcId.name() : null);
        this.newObjectId = srcId != null ? srcId : ObjectId.zeroId();
        this.remoteName = remoteName;
        this.forceUpdate = forceUpdate;
        if (localName != null && localDb != null) {
            this.localUpdate = localDb.updateRef(localName);
            this.localUpdate.setForceUpdate(true);
            this.localUpdate.setRefLogMessage("push", true);
            this.localUpdate.setNewObjectId(this.newObjectId);
            this.trackingRefUpdate = new TrackingRefUpdate(true, remoteName, localName, this.localUpdate.getOldObjectId() != null ? this.localUpdate.getOldObjectId() : ObjectId.zeroId(), this.newObjectId);
        } else {
            this.trackingRefUpdate = null;
        }
        this.localDb = localDb;
        this.expectedOldObjectId = expectedOldObjectId;
        this.status = Status.NOT_ATTEMPTED;
    }

    public RemoteRefUpdate(RemoteRefUpdate base, ObjectId newExpectedOldObjectId) throws IOException {
        this(base.localDb, base.srcRef, base.remoteName, base.forceUpdate, base.trackingRefUpdate == null ? null : base.trackingRefUpdate.getLocalName(), newExpectedOldObjectId);
    }

    public ObjectId getExpectedOldObjectId() {
        return this.expectedOldObjectId;
    }

    public boolean isExpectingOldObjectId() {
        return this.expectedOldObjectId != null;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public boolean isDelete() {
        return ObjectId.zeroId().equals(this.newObjectId);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public TrackingRefUpdate getTrackingRefUpdate() {
        return this.trackingRefUpdate;
    }

    public String getSrcRef() {
        return this.srcRef;
    }

    public boolean hasTrackingRefUpdate() {
        return this.trackingRefUpdate != null;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isFastForward() {
        return this.fastForward;
    }

    public String getMessage() {
        return this.message;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    void setFastForward(boolean fastForward) {
        this.fastForward = fastForward;
    }

    void setMessage(String message) {
        this.message = message;
    }

    protected void updateTrackingRef(RevWalk walk) throws IOException {
        if (this.isDelete()) {
            this.trackingRefUpdate.setResult(this.localUpdate.delete(walk));
        } else {
            this.trackingRefUpdate.setResult(this.localUpdate.update(walk));
        }
    }

    public String toString() {
        String string;
        String string2 = String.valueOf(String.valueOf(this.remoteName));
        String string3 = String.valueOf(String.valueOf((Object)this.status));
        String string4 = String.valueOf(String.valueOf(this.expectedOldObjectId != null ? this.expectedOldObjectId.name() : "(null)"));
        String string5 = String.valueOf(String.valueOf(this.newObjectId != null ? this.newObjectId.name() : "(null)"));
        String string6 = String.valueOf(String.valueOf(this.fastForward ? ", fastForward" : ""));
        String string7 = String.valueOf(String.valueOf(this.srcRef));
        String string8 = String.valueOf(String.valueOf(this.forceUpdate ? ", forceUpdate" : ""));
        if (this.message != null) {
            String string9 = String.valueOf(String.valueOf(this.message));
            string = new StringBuilder(2 + string9.length()).append("\"").append(string9).append("\"").toString();
        } else {
            string = "null";
        }
        String string10 = String.valueOf(String.valueOf(string));
        return new StringBuilder(54 + string2.length() + string3.length() + string4.length() + string5.length() + string6.length() + string7.length() + string8.length() + string10.length()).append("RemoteRefUpdate[remoteName=").append(string2).append(", ").append(string3).append(", ").append(string4).append("...").append(string5).append(string6).append(", srcRef=").append(string7).append(string8).append(", message=").append(string10).append("]").toString();
    }

    public static enum Status {
        NOT_ATTEMPTED,
        UP_TO_DATE,
        REJECTED_NONFASTFORWARD,
        REJECTED_NODELETE,
        REJECTED_REMOTE_CHANGED,
        REJECTED_OTHER_REASON,
        NON_EXISTING,
        AWAITING_REPORT,
        OK;

    }
}

