/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Arrays;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class UsernamePasswordCredentialsProvider
extends CredentialsProvider {
    private String username;
    private char[] password;

    public UsernamePasswordCredentialsProvider(String username, String password) {
        this(username, password.toCharArray());
    }

    public UsernamePasswordCredentialsProvider(String username, char[] password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean isInteractive() {
        return false;
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(this.username);
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(this.password);
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(new String(this.password));
                continue;
            }
            String string = String.valueOf(String.valueOf(i.getClass().getName()));
            String string2 = String.valueOf(String.valueOf(i.getPromptText()));
            throw new UnsupportedCredentialItem(uri, new StringBuilder(1 + string.length() + string2.length()).append(string).append(":").append(string2).toString());
        }
        return true;
    }

    public void clear() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
    }
}

