
package com.google.gerrit.server.change;

import com.google.common.hash.HashCode;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.Side;
import com.google.gerrit.reviewdb.client.CommentRange;
import com.google.gerrit.reviewdb.client.Patch.Key;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_PostReview_CommentSetEntry extends PostReview.CommentSetEntry {

  private final Key key;
  private final Integer line;
  private final Side side;
  private final HashCode message;
  private final CommentRange range;

  AutoValue_PostReview_CommentSetEntry(
      Key key,
      @Nullable Integer line,
      Side side,
      HashCode message,
      @Nullable CommentRange range) {
    if (key == null) {
      throw new NullPointerException("Null key");
    }
    this.key = key;
    this.line = line;
    if (side == null) {
      throw new NullPointerException("Null side");
    }
    this.side = side;
    if (message == null) {
      throw new NullPointerException("Null message");
    }
    this.message = message;
    this.range = range;
  }

  @Override
  Key key() {
    return key;
  }

  @Nullable
  @Override
  Integer line() {
    return line;
  }

  @Override
  Side side() {
    return side;
  }

  @Override
  HashCode message() {
    return message;
  }

  @Nullable
  @Override
  CommentRange range() {
    return range;
  }

  @Override
  public String toString() {
    return "CommentSetEntry{"
        + "key=" + key + ", "
        + "line=" + line + ", "
        + "side=" + side + ", "
        + "message=" + message + ", "
        + "range=" + range
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PostReview.CommentSetEntry) {
      PostReview.CommentSetEntry that = (PostReview.CommentSetEntry) o;
      return (this.key.equals(that.key()))
           && ((this.line == null) ? (that.line() == null) : this.line.equals(that.line()))
           && (this.side.equals(that.side()))
           && (this.message.equals(that.message()))
           && ((this.range == null) ? (that.range() == null) : this.range.equals(that.range()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.key.hashCode();
    h *= 1000003;
    h ^= (line == null) ? 0 : this.line.hashCode();
    h *= 1000003;
    h ^= this.side.hashCode();
    h *= 1000003;
    h ^= this.message.hashCode();
    h *= 1000003;
    h ^= (range == null) ? 0 : this.range.hashCode();
    return h;
  }

}
