
package com.google.gerrit.server.index;

import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_QueryOptions extends QueryOptions {

  private final IndexConfig config;
  private final int start;
  private final int limit;
  private final ImmutableSet<String> fields;

  AutoValue_QueryOptions(
      IndexConfig config,
      int start,
      int limit,
      ImmutableSet<String> fields) {
    if (config == null) {
      throw new NullPointerException("Null config");
    }
    this.config = config;
    this.start = start;
    this.limit = limit;
    if (fields == null) {
      throw new NullPointerException("Null fields");
    }
    this.fields = fields;
  }

  @Override
  public IndexConfig config() {
    return config;
  }

  @Override
  public int start() {
    return start;
  }

  @Override
  public int limit() {
    return limit;
  }

  @Override
  public ImmutableSet<String> fields() {
    return fields;
  }

  @Override
  public String toString() {
    return "QueryOptions{"
        + "config=" + config + ", "
        + "start=" + start + ", "
        + "limit=" + limit + ", "
        + "fields=" + fields
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryOptions) {
      QueryOptions that = (QueryOptions) o;
      return (this.config.equals(that.config()))
           && (this.start == that.start())
           && (this.limit == that.limit())
           && (this.fields.equals(that.fields()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.config.hashCode();
    h *= 1000003;
    h ^= this.start;
    h *= 1000003;
    h ^= this.limit;
    h *= 1000003;
    h ^= this.fields.hashCode();
    return h;
  }

}
