/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

@GwtIncompatible(value="Unemulated methods in Class and OutputStream")
public final class IoUtil {
    public static void copyWithThread(final InputStream src, final OutputStream dst) {
        new Thread("IoUtil-Copy"){

            @Override
            public void run() {
                try {
                    int n;
                    byte[] buf = new byte[256];
                    while (0 < (n = src.read(buf))) {
                        dst.write(buf, 0, n);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        src.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }.start();
    }

    public static void loadJARs(Collection<Path> jars) {
        Method addURL;
        if (jars.isEmpty()) {
            return;
        }
        ClassLoader cl = IoUtil.class.getClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            throw IoUtil.noAddURL("Not loaded by URLClassLoader", null);
        }
        URLClassLoader urlClassLoader = (URLClassLoader)cl;
        try {
            addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURL.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw IoUtil.noAddURL("Method addURL not available", e);
        }
        HashSet<URL> have = Sets.newHashSet(Arrays.asList(urlClassLoader.getURLs()));
        for (Path path : jars) {
            try {
                URL url = path.toUri().toURL();
                if (!have.add(url)) continue;
                addURL.invoke((Object)cl, url);
            }
            catch (IllegalAccessException | IllegalArgumentException | MalformedURLException e) {
                throw IoUtil.noAddURL("addURL " + path + " failed", e);
            }
            catch (InvocationTargetException e) {
                throw IoUtil.noAddURL("addURL " + path + " failed", e.getCause());
            }
        }
    }

    public static void loadJARs(Path jar) {
        IoUtil.loadJARs(Collections.singleton(jar));
    }

    private static UnsupportedOperationException noAddURL(String m, Throwable why) {
        String prefix = "Cannot extend classpath: ";
        return new UnsupportedOperationException(prefix + m, why);
    }

    private IoUtil() {
    }
}

