/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.common.annotations.GwtIncompatible;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.transport.RefSpec;

@GwtIncompatible(value="Unemulated org.eclipse.jgit.transport.RefSpec")
public class SubscribeSection {
    private final List<RefSpec> multiMatchRefSpecs;
    private final List<RefSpec> matchingRefSpecs;
    private final Project.NameKey project;

    public SubscribeSection(Project.NameKey p) {
        this.project = p;
        this.matchingRefSpecs = new ArrayList<RefSpec>();
        this.multiMatchRefSpecs = new ArrayList<RefSpec>();
    }

    public void addMatchingRefSpec(RefSpec spec) {
        this.matchingRefSpecs.add(spec);
    }

    public void addMatchingRefSpec(String spec) {
        RefSpec r = new RefSpec(spec);
        this.matchingRefSpecs.add(r);
    }

    public void addMultiMatchRefSpec(String spec) {
        RefSpec r = new RefSpec(spec, RefSpec.WildcardMode.ALLOW_MISMATCH);
        this.multiMatchRefSpecs.add(r);
    }

    public Project.NameKey getProject() {
        return this.project;
    }

    public boolean appliesTo(Branch.NameKey branch) {
        for (RefSpec r : this.matchingRefSpecs) {
            if (!r.matchSource(branch.get())) continue;
            return true;
        }
        for (RefSpec r : this.multiMatchRefSpecs) {
            if (!r.matchSource(branch.get())) continue;
            return true;
        }
        return false;
    }

    public Collection<RefSpec> getMatchingRefSpecs() {
        return Collections.unmodifiableCollection(this.matchingRefSpecs);
    }

    public Collection<RefSpec> getMultiMatchRefSpecs() {
        return Collections.unmodifiableCollection(this.multiMatchRefSpecs);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[SubscribeSection, project=");
        ret.append(this.project);
        if (!this.matchingRefSpecs.isEmpty()) {
            ret.append(", matching=[");
            for (RefSpec r : this.matchingRefSpecs) {
                ret.append(r.toString());
                ret.append(", ");
            }
        }
        if (!this.multiMatchRefSpecs.isEmpty()) {
            ret.append(", all=[");
            for (RefSpec r : this.multiMatchRefSpecs) {
                ret.append(r.toString());
                ret.append(", ");
            }
        }
        ret.append("]");
        return ret.toString();
    }
}

