/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.changes;

import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.common.DiffInfo;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.OptionalInt;

public interface FileApi {
    public BinaryResult content() throws RestApiException;

    public DiffInfo diff() throws RestApiException;

    public DiffInfo diff(String var1) throws RestApiException;

    public DiffInfo diff(int var1) throws RestApiException;

    public DiffRequest diffRequest() throws RestApiException;

    public static class NotImplemented
    implements FileApi {
        @Override
        public BinaryResult content() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public DiffInfo diff() throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public DiffInfo diff(String base) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public DiffInfo diff(int parent) throws RestApiException {
            throw new NotImplementedException();
        }

        @Override
        public DiffRequest diffRequest() throws RestApiException {
            throw new NotImplementedException();
        }
    }

    public static abstract class DiffRequest {
        private String base;
        private Integer context;
        private Boolean intraline;
        private DiffPreferencesInfo.Whitespace whitespace;
        private OptionalInt parent = OptionalInt.empty();

        public abstract DiffInfo get() throws RestApiException;

        public DiffRequest withBase(String base) {
            this.base = base;
            return this;
        }

        public DiffRequest withContext(int context) {
            this.context = context;
            return this;
        }

        public DiffRequest withIntraline(boolean intraline) {
            this.intraline = intraline;
            return this;
        }

        public DiffRequest withWhitespace(DiffPreferencesInfo.Whitespace whitespace) {
            this.whitespace = whitespace;
            return this;
        }

        public DiffRequest withParent(int parent) {
            this.parent = OptionalInt.of(parent);
            return this;
        }

        public String getBase() {
            return this.base;
        }

        public Integer getContext() {
            return this.context;
        }

        public Boolean getIntraline() {
            return this.intraline;
        }

        public DiffPreferencesInfo.Whitespace getWhitespace() {
            return this.whitespace;
        }

        public OptionalInt getParent() {
            return this.parent;
        }
    }
}

