/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.extensions.api.plugins;

import com.google.gerrit.extensions.api.plugins.PluginApi;
import com.google.gerrit.extensions.common.InstallPluginInput;
import com.google.gerrit.extensions.common.PluginInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public interface Plugins {
    public ListRequest list() throws RestApiException;

    public PluginApi name(String var1) throws RestApiException;

    public PluginApi install(String var1, InstallPluginInput var2) throws RestApiException;

    public static class NotImplemented
    implements Plugins {
        @Override
        public ListRequest list() {
            throw new NotImplementedException();
        }

        @Override
        public PluginApi name(String name) {
            throw new NotImplementedException();
        }

        @Override
        public PluginApi install(String name, InstallPluginInput input) throws RestApiException {
            throw new NotImplementedException();
        }
    }

    public static abstract class ListRequest {
        private boolean all;
        private int limit;
        private int start;
        private String substring;
        private String prefix;
        private String regex;

        public List<PluginInfo> get() throws RestApiException {
            SortedMap<String, PluginInfo> map = this.getAsMap();
            ArrayList<PluginInfo> result = new ArrayList<PluginInfo>(map.size());
            for (Map.Entry e : map.entrySet()) {
                result.add((PluginInfo)e.getValue());
            }
            return result;
        }

        public abstract SortedMap<String, PluginInfo> getAsMap() throws RestApiException;

        public ListRequest all() {
            this.all = true;
            return this;
        }

        public boolean getAll() {
            return this.all;
        }

        public ListRequest limit(int limit) {
            this.limit = limit;
            return this;
        }

        public int getLimit() {
            return this.limit;
        }

        public ListRequest start(int start) {
            this.start = start;
            return this;
        }

        public int getStart() {
            return this.start;
        }

        public ListRequest substring(String substring) {
            this.substring = substring;
            return this;
        }

        public String getSubstring() {
            return this.substring;
        }

        public ListRequest prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public ListRequest regex(String regex) {
            this.regex = regex;
            return this;
        }

        public String getRegex() {
            return this.regex;
        }
    }
}

