/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.collect.ImmutableMap;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Config;

@Singleton
public class GetUserFilter
implements Filter {
    public static final String USER_ATTR_KEY = "User";
    private final Provider<CurrentUser> userProvider;
    private boolean reqEnabled;
    private boolean resEnabled;

    @Inject
    GetUserFilter(Provider<CurrentUser> userProvider) {
        this.userProvider = userProvider;
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        CurrentUser user = this.userProvider.get();
        if (user != null && user.isIdentifiedUser()) {
            IdentifiedUser who = user.asIdentifiedUser();
            String loggableName = who.getUserName() != null && !who.getUserName().isEmpty() ? who.getUserName() : "a/" + who.getAccountId();
            if (this.reqEnabled) {
                req.setAttribute(USER_ATTR_KEY, loggableName);
            }
            if (this.resEnabled && resp instanceof HttpServletResponse) {
                ((HttpServletResponse)resp).addHeader(USER_ATTR_KEY, loggableName);
            }
        }
        chain.doFilter(req, resp);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig arg0) {
        this.reqEnabled = arg0.getInitParameter("reqEnabled") != null;
        this.resEnabled = arg0.getInitParameter("resEnabled") != null;
    }

    public static class Module
    extends ServletModule {
        private final boolean reqEnabled;
        private final boolean resEnabled;

        @Inject
        Module(@GerritServerConfig Config cfg) {
            this.reqEnabled = cfg.getBoolean("http", "addUserAsRequestAttribute", true);
            this.resEnabled = cfg.getBoolean("http", "addUserAsResponseHeader", false);
        }

        @Override
        protected void configureServlets() {
            if (this.resEnabled || this.reqEnabled) {
                ImmutableMap.Builder<String, String> initParams = ImmutableMap.builder();
                if (this.reqEnabled) {
                    initParams.put("reqEnabled", "");
                }
                if (this.resEnabled) {
                    initParams.put("resEnabled", "");
                }
                this.filter("/*", new String[0]).through(GetUserFilter.class, initParams.build());
            }
        }
    }
}

