/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.io.ByteStreams;
import com.google.gerrit.common.TimeUtil;
import com.google.gwtexpui.server.CacheHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BazelBuild {
    private static final Logger log = LoggerFactory.getLogger(BazelBuild.class);
    private final Path sourceRoot;

    public BazelBuild(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Label label) throws IOException, BuildFailureException {
        int status;
        byte[] out;
        ProcessBuilder proc = this.newBuildProcess(label);
        proc.directory(this.sourceRoot.toFile()).redirectErrorStream(true);
        log.info("building " + label.fullName());
        long start = TimeUtil.nowMs();
        Process rebuild = proc.start();
        try (InputStream in = rebuild.getInputStream();){
            out = ByteStreams.toByteArray(in);
        }
        finally {
            rebuild.getOutputStream().close();
        }
        try {
            status = rebuild.waitFor();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("interrupted waiting for: " + Joiner.on(' ').join(proc.command()));
        }
        if (status != 0) {
            log.warn("build failed: " + new String(out, StandardCharsets.UTF_8));
            throw new BuildFailureException(out);
        }
        long time = TimeUtil.nowMs() - start;
        log.info(String.format("UPDATED    %s in %.3fs", label.fullName(), (double)time / 1000.0));
    }

    private Properties loadBuildProperties(Path propPath) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(propPath, new OpenOption[0]);){
            properties.load(in);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        return properties;
    }

    private ProcessBuilder newBuildProcess(Label label) throws IOException {
        Properties properties = this.loadBuildProperties(this.sourceRoot.resolve(".bazel_path"));
        String bazel = MoreObjects.firstNonNull(properties.getProperty("bazel"), "bazel");
        ProcessBuilder proc = new ProcessBuilder(bazel, "build", label.fullName());
        if (properties.containsKey("PATH")) {
            proc.environment().put("PATH", properties.getProperty("PATH"));
        }
        return proc;
    }

    public Path targetPath(Label l) {
        return this.sourceRoot.resolve("bazel-bin").resolve(l.pkg).resolve(l.name);
    }

    public Label gwtZipLabel(String agent) {
        return new Label("gerrit-gwtui", "ui_" + agent + ".zip");
    }

    public Label polygerritComponents() {
        return new Label("polygerrit-ui", "polygerrit_components.bower_components.zip");
    }

    public Label fontZipLabel() {
        return new Label("polygerrit-ui", "fonts.zip");
    }

    static class BuildFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final byte[] why;

        BuildFailureException(byte[] why) {
            this.why = why;
        }

        public void display(String rule, HttpServletResponse res) throws IOException {
            res.setStatus(500);
            res.setContentType("text/html");
            res.setCharacterEncoding(StandardCharsets.UTF_8.name());
            CacheHeaders.setNotCacheable(res);
            Escaper html = HtmlEscapers.htmlEscaper();
            try (PrintWriter w = res.getWriter();){
                w.write("<html><title>BUILD FAILED</title><body>");
                w.format("<h1>%s FAILED</h1>", html.escape(rule));
                w.write("<pre>");
                w.write(html.escape(RawParseUtils.decode(this.why)));
                w.write("</pre>");
                w.write("</body></html>");
            }
        }
    }

    static class Label {
        protected final String pkg;
        protected final String name;

        public String fullName() {
            return "//" + this.pkg + ":" + this.name;
        }

        public String toString() {
            return this.fullName();
        }

        Label(String pkg, String name) {
            this.name = name;
            this.pkg = pkg;
        }
    }
}

