/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class CatServlet
extends HttpServlet {
    private final Provider<ReviewDb> requestDb;
    private final Provider<CurrentUser> userProvider;
    private final ChangeEditUtil changeEditUtil;
    private final PatchSetUtil psUtil;
    private final ChangeNotes.Factory changeNotesFactory;
    private final PermissionBackend permissionBackend;

    @Inject
    CatServlet(Provider<ReviewDb> sf, Provider<CurrentUser> usrprv, ChangeEditUtil ceu, PatchSetUtil psu, ChangeNotes.Factory cnf, PermissionBackend pb) {
        this.requestDb = sf;
        this.userProvider = usrprv;
        this.changeEditUtil = ceu;
        this.psUtil = psu;
        this.changeNotesFactory = cnf;
        this.permissionBackend = pb;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String revision;
        Patch.Key patchKey;
        int side;
        String keyStr = req.getPathInfo();
        if (!(keyStr = Url.decode(keyStr)).startsWith("/")) {
            rsp.sendError(404);
            return;
        }
        int c = (keyStr = keyStr.substring(1)).lastIndexOf(94);
        if (c == 0) {
            rsp.sendError(404);
            return;
        }
        if (c < 0) {
            side = 0;
        } else {
            try {
                side = Integer.parseInt(keyStr.substring(c + 1));
                keyStr = keyStr.substring(0, c);
            }
            catch (NumberFormatException e) {
                rsp.sendError(404);
                return;
            }
        }
        try {
            patchKey = Patch.Key.parse(keyStr);
        }
        catch (NumberFormatException e) {
            rsp.sendError(404);
            return;
        }
        Change.Id changeId = patchKey.getParentKey().getParentKey();
        try {
            ChangeNotes notes = this.changeNotesFactory.createChecked(changeId);
            ((PermissionBackend.ForChange)this.permissionBackend.user(this.userProvider).change(notes).database(this.requestDb)).check(ChangePermission.READ);
            if (patchKey.getParentKey().get() == 0) {
                Optional<ChangeEdit> edit = this.changeEditUtil.byChange(notes);
                if (!edit.isPresent()) {
                    rsp.sendError(404);
                    return;
                }
                revision = ObjectId.toString(edit.get().getEditCommit());
            } else {
                PatchSet patchSet = this.psUtil.get(this.requestDb.get(), notes, patchKey.getParentKey());
                if (patchSet == null) {
                    rsp.sendError(404);
                    return;
                }
                revision = patchSet.getRevision().get();
            }
        }
        catch (AuthException | NoSuchChangeException e) {
            rsp.sendError(404);
            return;
        }
        catch (PermissionBackendException | OrmException e) {
            this.getServletContext().log("Cannot query database", e);
            rsp.sendError(500);
            return;
        }
        String path = patchKey.getFileName();
        String restUrl = String.format("%s/changes/%d/revisions/%s/files/%s/download?parent=%d", req.getContextPath(), changeId.get(), revision, Url.encode(path), side);
        rsp.sendRedirect(restUrl);
    }
}

