/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.resources;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.httpd.resources.Resource;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SmallResource
extends Resource {
    private static final long serialVersionUID = 1L;
    private final byte[] data;
    private String contentType;
    private String characterEncoding;
    private long lastModified;

    public SmallResource(byte[] data) {
        this.data = data;
    }

    public SmallResource setLastModified(long when) {
        this.lastModified = when;
        return this;
    }

    public SmallResource setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public SmallResource setCharacterEncoding(@Nullable String enc) {
        this.characterEncoding = enc;
        return this;
    }

    @Override
    public int weigh() {
        return this.contentType.length() * 2 + this.data.length;
    }

    @Override
    public void send(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (0L < this.lastModified) {
            long ifModifiedSince = req.getDateHeader("If-Modified-Since");
            if (ifModifiedSince > 0L && ifModifiedSince == this.lastModified) {
                res.setStatus(304);
                return;
            }
            res.setDateHeader("Last-Modified", this.lastModified);
        }
        res.setContentType(this.contentType);
        if (this.characterEncoding != null) {
            res.setCharacterEncoding(this.characterEncoding);
        }
        res.setContentLength(this.data.length);
        res.getOutputStream().write(this.data);
    }

    @Override
    public boolean isUnchanged(long lastModified) {
        return this.lastModified == lastModified;
    }
}

