/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index.query;

import com.google.common.base.Preconditions;
import com.google.gerrit.index.query.Matchable;
import com.google.gerrit.index.query.Predicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OrPredicate<T>
extends Predicate<T>
implements Matchable<T> {
    private final List<Predicate<T>> children;
    private final int cost;

    @SafeVarargs
    protected OrPredicate(Predicate<T> ... that) {
        this(Arrays.asList(that));
    }

    protected OrPredicate(Collection<? extends Predicate<T>> that) {
        ArrayList<Predicate<T>> t = new ArrayList<Predicate<T>>(that.size());
        int c = 0;
        for (Predicate<T> p : that) {
            if (this.getClass() == p.getClass()) {
                for (Predicate<T> gp : p.getChildren()) {
                    t.add(gp);
                    c += gp.estimateCost();
                }
                continue;
            }
            t.add(p);
            c += p.estimateCost();
        }
        this.children = t;
        this.cost = c;
    }

    @Override
    public final List<Predicate<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public final int getChildCount() {
        return this.children.size();
    }

    @Override
    public final Predicate<T> getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        return new OrPredicate<T>(children);
    }

    @Override
    public boolean isMatchable() {
        for (Predicate<T> c : this.children) {
            if (c.isMatchable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean match(T object) throws OrmException {
        for (Predicate<T> c : this.children) {
            Preconditions.checkState(c.isMatchable(), "match invoked, but child predicate %s doesn't implement %s", c, (Object)Matchable.class.getName());
            if (!c.asMatchable().match(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int hashCode() {
        return this.getChild(0).hashCode() * 31 + this.getChild(1).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.getClass() == other.getClass() && this.getChildren().equals(((Predicate)other).getChildren());
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("(");
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i != 0) {
                r.append(" OR ");
            }
            r.append(this.getChild(i));
        }
        r.append(")");
        return r.toString();
    }
}

