/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.StoredValue;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.account.Emails;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListKey;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.googlecode.prolog_cafe.exceptions.SystemException;
import com.googlecode.prolog_cafe.lang.Prolog;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public final class StoredValues {
    public static final StoredValue<Accounts> ACCOUNTS = StoredValue.create(Accounts.class);
    public static final StoredValue<AccountCache> ACCOUNT_CACHE = StoredValue.create(AccountCache.class);
    public static final StoredValue<Emails> EMAILS = StoredValue.create(Emails.class);
    public static final StoredValue<ReviewDb> REVIEW_DB = StoredValue.create(ReviewDb.class);
    public static final StoredValue<ChangeData> CHANGE_DATA = StoredValue.create(ChangeData.class);
    public static final StoredValue<CurrentUser> CURRENT_USER = StoredValue.create(CurrentUser.class);
    public static final StoredValue<ProjectState> PROJECT_STATE = StoredValue.create(ProjectState.class);
    public static final StoredValue<PatchSetInfo> PATCH_SET_INFO = new StoredValue<PatchSetInfo>(){

        @Override
        public PatchSetInfo createValue(Prolog engine) {
            Change change = StoredValues.getChange(engine);
            PatchSet ps = StoredValues.getPatchSet(engine);
            PrologEnvironment env = (PrologEnvironment)engine.control;
            PatchSetInfoFactory patchInfoFactory = env.getArgs().getPatchSetInfoFactory();
            try {
                return patchInfoFactory.get(change.getProject(), ps);
            }
            catch (PatchSetInfoNotAvailableException e) {
                throw new SystemException(e.getMessage());
            }
        }
    };
    public static final StoredValue<PatchList> PATCH_LIST = new StoredValue<PatchList>(){

        @Override
        public PatchList createValue(Prolog engine) {
            PatchList patchList;
            PrologEnvironment env = (PrologEnvironment)engine.control;
            PatchSet ps = StoredValues.getPatchSet(engine);
            PatchListCache plCache = env.getArgs().getPatchListCache();
            Change change = StoredValues.getChange(engine);
            Project.NameKey project = change.getProject();
            ObjectId b = ObjectId.fromString(ps.getRevision().get());
            DiffPreferencesInfo.Whitespace ws = DiffPreferencesInfo.Whitespace.IGNORE_NONE;
            PatchListKey plKey = PatchListKey.againstDefaultBase(b, ws);
            try {
                patchList = plCache.get(plKey, project);
            }
            catch (PatchListNotAvailableException e) {
                throw new SystemException("Cannot create " + plKey);
            }
            return patchList;
        }
    };
    public static final StoredValue<Repository> REPOSITORY = new StoredValue<Repository>(){

        @Override
        public Repository createValue(Prolog engine) {
            Repository repo;
            PrologEnvironment env = (PrologEnvironment)engine.control;
            GitRepositoryManager gitMgr = env.getArgs().getGitRepositoryManager();
            Change change = StoredValues.getChange(engine);
            Project.NameKey projectKey = change.getProject();
            try {
                repo = gitMgr.openRepository(projectKey);
            }
            catch (IOException e) {
                throw new SystemException(e.getMessage());
            }
            env.addToCleanup(repo::close);
            return repo;
        }
    };
    public static final StoredValue<PermissionBackend> PERMISSION_BACKEND = new StoredValue<PermissionBackend>(){

        @Override
        protected PermissionBackend createValue(Prolog engine) {
            PrologEnvironment env = (PrologEnvironment)engine.control;
            return env.getArgs().getPermissionBackend();
        }
    };
    public static final StoredValue<AnonymousUser> ANONYMOUS_USER = new StoredValue<AnonymousUser>(){

        @Override
        protected AnonymousUser createValue(Prolog engine) {
            PrologEnvironment env = (PrologEnvironment)engine.control;
            return env.getArgs().getAnonymousUser();
        }
    };
    public static final StoredValue<Map<Account.Id, IdentifiedUser>> USERS = new StoredValue<Map<Account.Id, IdentifiedUser>>(){

        @Override
        protected Map<Account.Id, IdentifiedUser> createValue(Prolog engine) {
            return new HashMap<Account.Id, IdentifiedUser>();
        }
    };

    public static Change getChange(Prolog engine) throws SystemException {
        ChangeData cd = CHANGE_DATA.get(engine);
        try {
            return cd.change();
        }
        catch (OrmException e) {
            throw new SystemException("Cannot load change " + cd.getId());
        }
    }

    public static PatchSet getPatchSet(Prolog engine) throws SystemException {
        ChangeData cd = CHANGE_DATA.get(engine);
        try {
            return cd.currentPatchSet();
        }
        catch (OrmException e) {
            throw new SystemException(e.getMessage());
        }
    }

    private StoredValues() {
    }
}

