/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import java.sql.Timestamp;

public class ReviewerByEmailSet {
    private static final ReviewerByEmailSet EMPTY = new ReviewerByEmailSet(ImmutableTable.of());
    private final ImmutableTable<ReviewerStateInternal, Address, Timestamp> table;
    private ImmutableSet<Address> users;

    public static ReviewerByEmailSet fromTable(Table<ReviewerStateInternal, Address, Timestamp> table) {
        return new ReviewerByEmailSet(table);
    }

    public static ReviewerByEmailSet empty() {
        return EMPTY;
    }

    private ReviewerByEmailSet(Table<ReviewerStateInternal, Address, Timestamp> table) {
        this.table = ImmutableTable.copyOf(table);
    }

    public ImmutableSet<Address> all() {
        if (this.users == null) {
            this.users = ImmutableSet.copyOf(this.table.columnKeySet());
        }
        return this.users;
    }

    public ImmutableSet<Address> byState(ReviewerStateInternal state) {
        return ((ImmutableMap)this.table.row((Object)state)).keySet();
    }

    public ImmutableTable<ReviewerStateInternal, Address, Timestamp> asTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        return o instanceof ReviewerByEmailSet && this.table.equals(((ReviewerByEmailSet)o).table);
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.table;
    }
}

