/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountConfig;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Accounts {
    private static final Logger log = LoggerFactory.getLogger(Accounts.class);
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;
    private final OutgoingEmailValidator emailValidator;

    @Inject
    Accounts(GitRepositoryManager repoManager, AllUsersName allUsersName, OutgoingEmailValidator emailValidator) {
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
        this.emailValidator = emailValidator;
    }

    public Account get(Account.Id accountId) throws IOException, ConfigInvalidException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            Account account = this.read(repo, accountId);
            return account;
        }
    }

    public List<Account> get(Collection<Account.Id> accountIds) throws IOException, ConfigInvalidException {
        ArrayList<Account> accounts = new ArrayList<Account>(accountIds.size());
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            for (Account.Id accountId : accountIds) {
                accounts.add(this.read(repo, accountId));
            }
        }
        return accounts;
    }

    public List<Account> all() throws IOException {
        Set<Account.Id> accountIds = this.allIds();
        ArrayList<Account> accounts = new ArrayList<Account>(accountIds.size());
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            for (Account.Id accountId : accountIds) {
                try {
                    accounts.add(this.read(repo, accountId));
                }
                catch (Exception e) {
                    log.error("Ignoring invalid account {}", (Object)accountId.get(), (Object)e);
                }
            }
        }
        return accounts;
    }

    public Set<Account.Id> allIds() throws IOException {
        return this.readUserRefs().collect(Collectors.toSet());
    }

    public List<Account.Id> firstNIds(int n) throws IOException {
        return this.readUserRefs().sorted(Comparator.comparing(id -> id.get())).limit(n).collect(Collectors.toList());
    }

    public boolean hasAnyAccount() throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            boolean bl = Accounts.hasAnyAccount(repo);
            return bl;
        }
    }

    public static boolean hasAnyAccount(Repository repo) throws IOException {
        return Accounts.readUserRefs(repo).findAny().isPresent();
    }

    private Stream<Account.Id> readUserRefs() throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            Stream<Account.Id> stream = Accounts.readUserRefs(repo);
            return stream;
        }
    }

    private Account read(Repository allUsersRepository, Account.Id accountId) throws IOException, ConfigInvalidException {
        AccountConfig accountConfig = new AccountConfig(this.emailValidator, accountId);
        accountConfig.load(allUsersRepository);
        return accountConfig.getAccount();
    }

    public static Stream<Account.Id> readUserRefs(Repository repo) throws IOException {
        return repo.getRefDatabase().getRefs("refs/users/").values().stream().map(r -> Account.Id.fromRef(r.getName())).filter(Objects::nonNull);
    }
}

