/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.InvalidUserNameException;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeUserName
implements Callable<VoidResult> {
    private static final Logger log = LoggerFactory.getLogger(ChangeUserName.class);
    public static final String USERNAME_CANNOT_BE_CHANGED = "Username cannot be changed.";
    private final SshKeyCache sshKeyCache;
    private final ExternalIds externalIds;
    private final ExternalIdsUpdate.Server externalIdsUpdateFactory;
    private final IdentifiedUser user;
    private final String newUsername;

    @Inject
    ChangeUserName(SshKeyCache sshKeyCache, ExternalIds externalIds, ExternalIdsUpdate.Server externalIdsUpdateFactory, @Assisted IdentifiedUser user, @Nullable @Assisted String newUsername) {
        this.sshKeyCache = sshKeyCache;
        this.externalIds = externalIds;
        this.externalIdsUpdateFactory = externalIdsUpdateFactory;
        this.user = user;
        this.newUsername = newUsername;
    }

    @Override
    public VoidResult call() throws OrmException, NameAlreadyUsedException, InvalidUserNameException, IOException, ConfigInvalidException {
        Set<ExternalId> old = this.externalIds.byAccount(this.user.getAccountId(), "username");
        if (!old.isEmpty()) {
            log.error("External id with scheme \"username:\" already exists for the user {}", (Object)this.user.getAccountId());
            throw new IllegalStateException(USERNAME_CANNOT_BE_CHANGED);
        }
        ExternalIdsUpdate externalIdsUpdate = this.externalIdsUpdateFactory.create();
        if (this.newUsername != null && !this.newUsername.isEmpty()) {
            if (!ExternalId.isValidUsername(this.newUsername)) {
                throw new InvalidUserNameException();
            }
            ExternalId.Key key = ExternalId.Key.create("username", this.newUsername);
            try {
                String password = null;
                for (ExternalId i : old) {
                    if (i.password() == null) continue;
                    password = i.password();
                }
                externalIdsUpdate.insert(ExternalId.create(key, this.user.getAccountId(), null, password));
                log.info("Created the new external Id with key: {}", (Object)key);
            }
            catch (OrmDuplicateKeyException dupeErr) {
                ExternalId other = this.externalIds.get(key);
                if (other != null && other.accountId().equals(this.user.getAccountId())) {
                    return VoidResult.INSTANCE;
                }
                throw new NameAlreadyUsedException(this.newUsername);
            }
        }
        externalIdsUpdate.delete(old);
        for (ExternalId extId : old) {
            this.sshKeyCache.evict(extId.key().id());
        }
        this.sshKeyCache.evict(this.newUsername);
        return VoidResult.INSTANCE;
    }

    public static interface Factory {
        public ChangeUserName create(IdentifiedUser var1, String var2);
    }
}

