/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.GroupIndexer;
import com.google.gerrit.server.query.group.InternalGroupQuery;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupCacheImpl
implements GroupCache {
    private static final Logger log = LoggerFactory.getLogger(GroupCacheImpl.class);
    private static final String BYID_NAME = "groups";
    private static final String BYNAME_NAME = "groups_byname";
    private static final String BYUUID_NAME = "groups_byuuid";
    private final LoadingCache<AccountGroup.Id, Optional<InternalGroup>> byId;
    private final LoadingCache<String, Optional<InternalGroup>> byName;
    private final LoadingCache<String, Optional<InternalGroup>> byUUID;
    private final Provider<GroupIndexer> indexer;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupCacheImpl.BYID_NAME, AccountGroup.Id.class, new TypeLiteral<Optional<InternalGroup>>(){}).loader(ByIdLoader.class);
                this.cache(GroupCacheImpl.BYNAME_NAME, String.class, new TypeLiteral<Optional<InternalGroup>>(){}).loader(ByNameLoader.class);
                this.cache(GroupCacheImpl.BYUUID_NAME, String.class, new TypeLiteral<Optional<InternalGroup>>(){}).loader(ByUUIDLoader.class);
                this.bind(GroupCacheImpl.class);
                this.bind(GroupCache.class).to(GroupCacheImpl.class);
            }
        };
    }

    @Inject
    GroupCacheImpl(@Named(value="groups") LoadingCache<AccountGroup.Id, Optional<InternalGroup>> byId, @Named(value="groups_byname") LoadingCache<String, Optional<InternalGroup>> byName, @Named(value="groups_byuuid") LoadingCache<String, Optional<InternalGroup>> byUUID, Provider<GroupIndexer> indexer) {
        this.byId = byId;
        this.byName = byName;
        this.byUUID = byUUID;
        this.indexer = indexer;
    }

    @Override
    public Optional<InternalGroup> get(AccountGroup.Id groupId) {
        try {
            return this.byId.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load group {}", (Object)groupId, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void evict(AccountGroup.UUID groupUuid, AccountGroup.Id groupId, AccountGroup.NameKey groupName) throws IOException {
        if (groupId != null) {
            this.byId.invalidate(groupId);
        }
        if (groupName != null) {
            this.byName.invalidate(groupName.get());
        }
        if (groupUuid != null) {
            this.byUUID.invalidate(groupUuid.get());
        }
        this.indexer.get().index(groupUuid);
    }

    @Override
    public void evictAfterRename(AccountGroup.NameKey oldName) throws IOException {
        if (oldName != null) {
            this.byName.invalidate(oldName.get());
        }
    }

    @Override
    public Optional<InternalGroup> get(AccountGroup.NameKey name) {
        if (name == null) {
            return Optional.empty();
        }
        try {
            return this.byName.get(name.get());
        }
        catch (ExecutionException e) {
            log.warn("Cannot look up group {} by name", (Object)name.get(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<InternalGroup> get(AccountGroup.UUID groupUuid) {
        if (groupUuid == null) {
            return Optional.empty();
        }
        try {
            return this.byUUID.get(groupUuid.get());
        }
        catch (ExecutionException e) {
            log.warn("Cannot look up group {} by uuid", (Object)groupUuid.get(), (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void onCreateGroup(AccountGroup group) throws IOException {
        this.indexer.get().index(group.getGroupUUID());
    }

    static class ByUUIDLoader
    extends CacheLoader<String, Optional<InternalGroup>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Groups groups;

        @Inject
        ByUUIDLoader(SchemaFactory<ReviewDb> sf, Groups groups) {
            this.schema = sf;
            this.groups = groups;
        }

        @Override
        public Optional<InternalGroup> load(String uuid) throws Exception {
            try (ReviewDb db = this.schema.open();){
                Optional<InternalGroup> optional = this.groups.getGroup(db, new AccountGroup.UUID(uuid));
                return optional;
            }
        }
    }

    static class ByNameLoader
    extends CacheLoader<String, Optional<InternalGroup>> {
        private final Provider<InternalGroupQuery> groupQueryProvider;

        @Inject
        ByNameLoader(Provider<InternalGroupQuery> groupQueryProvider) {
            this.groupQueryProvider = groupQueryProvider;
        }

        @Override
        public Optional<InternalGroup> load(String name) throws Exception {
            return this.groupQueryProvider.get().byName(new AccountGroup.NameKey(name));
        }
    }

    static class ByIdLoader
    extends CacheLoader<AccountGroup.Id, Optional<InternalGroup>> {
        private final SchemaFactory<ReviewDb> schema;
        private final Groups groups;
        private final BooleanSupplier hasGroupIndex;
        private final Provider<InternalGroupQuery> groupQueryProvider;

        @Inject
        ByIdLoader(SchemaFactory<ReviewDb> schema, Groups groups, GroupIndexCollection groupIndexCollection, Provider<InternalGroupQuery> groupQueryProvider) {
            this.schema = schema;
            this.groups = groups;
            this.hasGroupIndex = () -> groupIndexCollection.getSearchIndex() != null;
            this.groupQueryProvider = groupQueryProvider;
        }

        @Override
        public Optional<InternalGroup> load(AccountGroup.Id key) throws Exception {
            if (this.hasGroupIndex.getAsBoolean()) {
                return this.groupQueryProvider.get().byId(key);
            }
            try (ReviewDb db = this.schema.open();){
                Optional<InternalGroup> optional = this.groups.getGroup(db, key);
                return optional;
            }
        }
    }
}

