/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.externalids.AutoValue_ExternalIdCacheImpl_AllExternalIds;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdCache;
import com.google.gerrit.server.account.externalids.ExternalIdReader;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class ExternalIdCacheImpl
implements ExternalIdCache {
    private static final Logger log = LoggerFactory.getLogger(ExternalIdCacheImpl.class);
    private final LoadingCache<ObjectId, AllExternalIds> extIdsByAccount;
    private final ExternalIdReader externalIdReader;
    private final Lock lock;

    @Inject
    ExternalIdCacheImpl(ExternalIdReader externalIdReader) {
        this.extIdsByAccount = CacheBuilder.newBuilder().maximumSize(1L).build(new Loader(externalIdReader));
        this.externalIdReader = externalIdReader;
        this.lock = new ReentrantLock(true);
    }

    @Override
    public void onCreate(ObjectId oldNotesRev, ObjectId newNotesRev, Collection<ExternalId> extIds) throws IOException {
        this.updateCache(oldNotesRev, newNotesRev, m -> {
            for (ExternalId extId : extIds) {
                extId.checkThatBlobIdIsSet();
                m.put(extId.accountId(), extId);
            }
        });
    }

    @Override
    public void onRemove(ObjectId oldNotesRev, ObjectId newNotesRev, Collection<ExternalId> extIds) throws IOException {
        this.updateCache(oldNotesRev, newNotesRev, m -> {
            for (ExternalId extId : extIds) {
                m.remove(extId.accountId(), extId);
            }
        });
    }

    @Override
    public void onUpdate(ObjectId oldNotesRev, ObjectId newNotesRev, Collection<ExternalId> updatedExtIds) throws IOException {
        this.updateCache(oldNotesRev, newNotesRev, m -> {
            ExternalIdCacheImpl.removeKeys(m.values(), updatedExtIds.stream().map(e -> e.key()).collect(Collectors.toSet()));
            for (ExternalId updatedExtId : updatedExtIds) {
                updatedExtId.checkThatBlobIdIsSet();
                m.put(updatedExtId.accountId(), updatedExtId);
            }
        });
    }

    @Override
    public void onReplace(ObjectId oldNotesRev, ObjectId newNotesRev, Account.Id accountId, Collection<ExternalId> toRemove, Collection<ExternalId> toAdd) throws IOException {
        ExternalIdsUpdate.checkSameAccount(Iterables.concat(toRemove, toAdd), accountId);
        this.updateCache(oldNotesRev, newNotesRev, m -> {
            for (ExternalId extId : toRemove) {
                m.remove(extId.accountId(), extId);
            }
            for (ExternalId extId : toAdd) {
                extId.checkThatBlobIdIsSet();
                m.put(extId.accountId(), extId);
            }
        });
    }

    @Override
    public void onReplace(ObjectId oldNotesRev, ObjectId newNotesRev, Collection<ExternalId> toRemove, Collection<ExternalId> toAdd) throws IOException {
        this.updateCache(oldNotesRev, newNotesRev, m -> {
            for (ExternalId extId : toRemove) {
                m.remove(extId.accountId(), extId);
            }
            for (ExternalId extId : toAdd) {
                extId.checkThatBlobIdIsSet();
                m.put(extId.accountId(), extId);
            }
        });
    }

    @Override
    public ImmutableSet<ExternalId> byAccount(Account.Id accountId) throws IOException {
        return this.get().byAccount().get((Object)accountId);
    }

    @Override
    public ImmutableSetMultimap<Account.Id, ExternalId> allByAccount() throws IOException {
        return this.get().byAccount();
    }

    @Override
    public ImmutableSetMultimap<String, ExternalId> byEmails(String ... emails) throws IOException {
        AllExternalIds allExternalIds = this.get();
        ImmutableSetMultimap.Builder byEmails = ImmutableSetMultimap.builder();
        for (String email : emails) {
            byEmails.putAll((Object)email, (Iterable)allExternalIds.byEmail().get((Object)email));
        }
        return byEmails.build();
    }

    @Override
    public ImmutableSetMultimap<String, ExternalId> allByEmail() throws IOException {
        return this.get().byEmail();
    }

    private AllExternalIds get() throws IOException {
        try {
            return this.extIdsByAccount.get(this.externalIdReader.readRevision());
        }
        catch (ExecutionException e) {
            throw new IOException("Cannot load external ids", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(ObjectId oldNotesRev, ObjectId newNotesRev, Consumer<Multimap<Account.Id, ExternalId>> update) {
        this.lock.lock();
        try {
            Multimap m = !ObjectId.zeroId().equals(oldNotesRev) ? MultimapBuilder.hashKeys().arrayListValues().build((Multimap)this.extIdsByAccount.get(oldNotesRev).byAccount()) : MultimapBuilder.hashKeys().arrayListValues().build();
            update.accept(m);
            this.extIdsByAccount.put(newNotesRev, AllExternalIds.create(m));
        }
        catch (ExecutionException e) {
            log.warn("Cannot update external IDs", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void removeKeys(Collection<ExternalId> ids, Collection<ExternalId.Key> toRemove) {
        Collections2.transform(ids, e -> e.key()).removeAll(toRemove);
    }

    @AutoValue
    static abstract class AllExternalIds {
        AllExternalIds() {
        }

        static AllExternalIds create(Multimap<Account.Id, ExternalId> byAccount) {
            ImmutableSetMultimap<String, ExternalId> byEmail = byAccount.values().stream().filter(e -> !Strings.isNullOrEmpty(e.email())).collect(ImmutableSetMultimap.toImmutableSetMultimap(ExternalId::email, e -> e));
            return new AutoValue_ExternalIdCacheImpl_AllExternalIds(ImmutableSetMultimap.copyOf(byAccount), byEmail);
        }

        public abstract ImmutableSetMultimap<Account.Id, ExternalId> byAccount();

        public abstract ImmutableSetMultimap<String, ExternalId> byEmail();
    }

    private static class Loader
    extends CacheLoader<ObjectId, AllExternalIds> {
        private final ExternalIdReader externalIdReader;

        Loader(ExternalIdReader externalIdReader) {
            this.externalIdReader = externalIdReader;
        }

        @Override
        public AllExternalIds load(ObjectId notesRev) throws Exception {
            Multimap extIdsByAccount = MultimapBuilder.hashKeys().arrayListValues().build();
            for (ExternalId extId : this.externalIdReader.all(notesRev)) {
                extId.checkThatBlobIdIsSet();
                extIdsByAccount.put(extId.accountId(), extId);
            }
            return AllExternalIds.create(extIdsByAccount);
        }
    }
}

