/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account.externalids;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIdCache;
import com.google.gerrit.server.account.externalids.ExternalIdReader;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class ExternalIds {
    private final ExternalIdReader externalIdReader;
    private final ExternalIdCache externalIdCache;

    @Inject
    public ExternalIds(ExternalIdReader externalIdReader, ExternalIdCache externalIdCache) {
        this.externalIdReader = externalIdReader;
        this.externalIdCache = externalIdCache;
    }

    public Set<ExternalId> all() throws IOException {
        return this.externalIdReader.all();
    }

    public Set<ExternalId> all(ObjectId rev) throws IOException {
        return this.externalIdReader.all(rev);
    }

    @Nullable
    public ExternalId get(ExternalId.Key key) throws IOException, ConfigInvalidException {
        return this.externalIdReader.get(key);
    }

    @Nullable
    public ExternalId get(ExternalId.Key key, ObjectId rev) throws IOException, ConfigInvalidException {
        return this.externalIdReader.get(key, rev);
    }

    public Set<ExternalId> byAccount(Account.Id accountId) throws IOException {
        return this.externalIdCache.byAccount(accountId);
    }

    public Set<ExternalId> byAccount(Account.Id accountId, String scheme) throws IOException {
        return this.byAccount(accountId).stream().filter(e -> e.key().isScheme(scheme)).collect(Collectors.toSet());
    }

    public ImmutableSetMultimap<Account.Id, ExternalId> allByAccount() throws IOException {
        return this.externalIdCache.allByAccount();
    }

    public Set<ExternalId> byEmail(String email) throws IOException {
        return this.externalIdCache.byEmail(email);
    }

    public ImmutableSetMultimap<String, ExternalId> byEmails(String ... emails) throws IOException {
        return this.externalIdCache.byEmails(emails);
    }

    public ImmutableSetMultimap<String, ExternalId> allByEmail() throws IOException {
        return this.externalIdCache.allByEmail();
    }
}

