/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;

@Singleton
public class CreateDraftComment
extends RetryingRestModifyView<RevisionResource, DraftInput, Response<CommentInfo>> {
    private final Provider<ReviewDb> db;
    private final Provider<CommentJson> commentJson;
    private final CommentsUtil commentsUtil;
    private final PatchSetUtil psUtil;
    private final PatchListCache patchListCache;

    @Inject
    CreateDraftComment(Provider<ReviewDb> db, RetryHelper retryHelper, Provider<CommentJson> commentJson, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache) {
        super(retryHelper);
        this.db = db;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
    }

    @Override
    protected Response<CommentInfo> applyImpl(BatchUpdate.Factory updateFactory, RevisionResource rsrc, DraftInput in) throws RestApiException, UpdateException, OrmException {
        if (Strings.isNullOrEmpty(in.path)) {
            throw new BadRequestException("path must be non-empty");
        }
        if (in.message == null || in.message.trim().isEmpty()) {
            throw new BadRequestException("message must be non-empty");
        }
        if (in.line != null && in.line < 0) {
            throw new BadRequestException("line must be >= 0");
        }
        if (in.line != null && in.range != null && in.line != in.range.endLine) {
            throw new BadRequestException("range endLine must be on the same line as the comment");
        }
        try (BatchUpdate bu = updateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            Op op = new Op(rsrc.getPatchSet().getId(), in);
            bu.addOp(rsrc.getChange().getId(), op);
            bu.execute();
            Response<CommentInfo> response = Response.created(this.commentJson.get().setFillAccounts(false).newCommentFormatter().format(op.comment));
            return response;
        }
    }

    private class Op
    implements BatchUpdateOp {
        private final PatchSet.Id psId;
        private final DraftInput in;
        private Comment comment;

        private Op(PatchSet.Id psId, DraftInput in) {
            this.psId = psId;
            this.in = in;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws ResourceNotFoundException, OrmException, UnprocessableEntityException, PatchListNotAvailableException {
            PatchSet ps = CreateDraftComment.this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.psId);
            if (ps == null) {
                throw new ResourceNotFoundException("patch set not found: " + this.psId);
            }
            String parentUuid = Url.decode(this.in.inReplyTo);
            this.comment = CreateDraftComment.this.commentsUtil.newComment(ctx, this.in.path, ps.getId(), this.in.side(), this.in.message.trim(), this.in.unresolved, parentUuid);
            this.comment.setLineNbrAndRange(this.in.line, this.in.range);
            this.comment.tag = this.in.tag;
            CommentsUtil.setCommentRevId(this.comment, CreateDraftComment.this.patchListCache, ctx.getChange(), ps);
            CreateDraftComment.this.commentsUtil.putComments(ctx.getDb(), ctx.getUpdate(this.psId), PatchLineComment.Status.DRAFT, Collections.singleton(this.comment));
            ctx.dontBumpLastUpdatedOn();
            return true;
        }
    }
}

