/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.ComparisonType;
import com.google.gerrit.server.patch.Text;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetContent
implements RestReadView<FileResource> {
    private final Provider<ReviewDb> db;
    private final GitRepositoryManager gitManager;
    private final PatchSetUtil psUtil;
    private final FileContentUtil fileContentUtil;
    private final ProjectCache projectCache;
    @Option(name="--parent")
    private Integer parent;

    @Inject
    GetContent(Provider<ReviewDb> db, GitRepositoryManager gitManager, PatchSetUtil psUtil, FileContentUtil fileContentUtil, ProjectCache projectCache) {
        this.db = db;
        this.gitManager = gitManager;
        this.psUtil = psUtil;
        this.fileContentUtil = fileContentUtil;
        this.projectCache = projectCache;
    }

    public BinaryResult apply(FileResource rsrc) throws ResourceNotFoundException, IOException, BadRequestException, OrmException {
        String path = rsrc.getPatchKey().get();
        if ("/COMMIT_MSG".equals(path)) {
            String msg = this.getMessage(rsrc.getRevision().getChangeResource().getNotes());
            return BinaryResult.create(msg).setContentType("text/x-gerrit-commit-message").base64();
        }
        if ("/MERGE_LIST".equals(path)) {
            byte[] mergeList = this.getMergeList(rsrc.getRevision().getChangeResource().getNotes());
            return BinaryResult.create(mergeList).setContentType("text/x-gerrit-merge-list").base64();
        }
        return this.fileContentUtil.getContent(this.projectCache.checkedGet(rsrc.getRevision().getProject()), ObjectId.fromString(rsrc.getRevision().getPatchSet().getRevision().get()), path, this.parent);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getMessage(ChangeNotes notes) throws OrmException, IOException {
        Change.Id changeId = notes.getChangeId();
        PatchSet ps = this.psUtil.current(this.db.get(), notes);
        if (ps == null) {
            throw new NoSuchChangeException(changeId);
        }
        try {
            Throwable throwable = null;
            try (Repository git = this.gitManager.openRepository(notes.getProjectName());){
                String string;
                RevWalk revWalk = new RevWalk(git);
                Throwable throwable2 = null;
                try {
                    RevCommit commit = revWalk.parseCommit(ObjectId.fromString(ps.getRevision().get()));
                    string = commit.getFullMessage();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            GetContent.$closeResource(throwable2, revWalk);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                GetContent.$closeResource(throwable2, revWalk);
                return string;
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new NoSuchChangeException(changeId, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getMergeList(ChangeNotes notes) throws OrmException, IOException {
        Change.Id changeId = notes.getChangeId();
        PatchSet ps = this.psUtil.current(this.db.get(), notes);
        if (ps == null) {
            throw new NoSuchChangeException(changeId);
        }
        try {
            Throwable throwable = null;
            try (Repository git = this.gitManager.openRepository(notes.getProjectName());){
                byte[] byArray;
                RevWalk revWalk = new RevWalk(git);
                Throwable throwable2 = null;
                try {
                    byArray = Text.forMergeList(ComparisonType.againstAutoMerge(), revWalk.getObjectReader(), ObjectId.fromString(ps.getRevision().get())).getContent();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            GetContent.$closeResource(throwable2, revWalk);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                GetContent.$closeResource(throwable2, revWalk);
                return byArray;
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new NoSuchChangeException(changeId, (Throwable)e);
        }
    }
}

