/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.RelatedChangesSorter;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class GetRelated
implements RestReadView<RevisionResource> {
    private final Provider<ReviewDb> db;
    private final Provider<InternalChangeQuery> queryProvider;
    private final PatchSetUtil psUtil;
    private final RelatedChangesSorter sorter;

    @Inject
    GetRelated(Provider<ReviewDb> db, Provider<InternalChangeQuery> queryProvider, PatchSetUtil psUtil, RelatedChangesSorter sorter) {
        this.db = db;
        this.queryProvider = queryProvider;
        this.psUtil = psUtil;
        this.sorter = sorter;
    }

    public RelatedInfo apply(RevisionResource rsrc) throws RepositoryNotFoundException, IOException, OrmException, NoSuchProjectException, PermissionBackendException {
        RelatedInfo relatedInfo = new RelatedInfo();
        relatedInfo.changes = this.getRelated(rsrc);
        return relatedInfo;
    }

    private List<ChangeAndCommit> getRelated(RevisionResource rsrc) throws OrmException, IOException, PermissionBackendException {
        Set<String> groups = this.getAllGroups(rsrc.getNotes());
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        List<ChangeData> cds = this.queryProvider.get().enforceVisibility(true).byProjectGroups(rsrc.getChange().getProject(), groups);
        if (cds.isEmpty()) {
            return Collections.emptyList();
        }
        if (cds.size() == 1 && cds.get(0).getId().equals(rsrc.getChange().getId())) {
            return Collections.emptyList();
        }
        ArrayList<ChangeAndCommit> result = new ArrayList<ChangeAndCommit>(cds.size());
        boolean isEdit = rsrc.getEdit().isPresent();
        PatchSet basePs = isEdit ? rsrc.getEdit().get().getBasePatchSet() : rsrc.getPatchSet();
        this.reloadChangeIfStale(cds, basePs);
        for (RelatedChangesSorter.PatchSetData d : this.sorter.sort(cds, basePs, rsrc.getUser())) {
            RevCommit commit;
            PatchSet ps = d.patchSet();
            if (isEdit && ps.getId().equals(basePs.getId())) {
                ps = rsrc.getPatchSet();
                commit = rsrc.getEdit().get().getEditCommit();
            } else {
                commit = d.commit();
            }
            result.add(new ChangeAndCommit(rsrc.getProject(), d.data().change(), ps, commit));
        }
        if (result.size() == 1) {
            ChangeAndCommit r = (ChangeAndCommit)result.get(0);
            if (r.commit != null && r.commit.commit.equals(rsrc.getPatchSet().getRevision().get())) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    private Set<String> getAllGroups(ChangeNotes notes) throws OrmException {
        HashSet<String> result = new HashSet<String>();
        for (PatchSet ps : this.psUtil.byChange(this.db.get(), notes)) {
            result.addAll(ps.getGroups());
        }
        return result;
    }

    private void reloadChangeIfStale(List<ChangeData> cds, PatchSet wantedPs) throws OrmException {
        for (ChangeData cd : cds) {
            if (!cd.getId().equals(wantedPs.getId().getParentKey()) || cd.patchSet(wantedPs.getId()) != null) continue;
            cd.reloadChange();
        }
    }

    public static class ChangeAndCommit {
        public String project;
        public String changeId;
        public CommitInfo commit;
        public Integer _changeNumber;
        public Integer _revisionNumber;
        public Integer _currentRevisionNumber;
        public String status;

        public ChangeAndCommit() {
        }

        ChangeAndCommit(Project.NameKey project, @Nullable Change change, @Nullable PatchSet ps, RevCommit c) {
            this.project = project.get();
            if (change != null) {
                this.changeId = change.getKey().get();
                this._changeNumber = change.getChangeId();
                this._revisionNumber = ps != null ? Integer.valueOf(ps.getPatchSetId()) : null;
                PatchSet.Id curr = change.currentPatchSetId();
                this._currentRevisionNumber = curr != null ? Integer.valueOf(curr.get()) : null;
                this.status = change.getStatus().asChangeStatus().toString();
            }
            this.commit = new CommitInfo();
            this.commit.commit = c.name();
            this.commit.parents = Lists.newArrayListWithCapacity(c.getParentCount());
            for (int i = 0; i < c.getParentCount(); ++i) {
                CommitInfo p = new CommitInfo();
                p.commit = c.getParent(i).name();
                this.commit.parents.add(p);
            }
            this.commit.author = CommonConverters.toGitPerson(c.getAuthorIdent());
            this.commit.subject = c.getShortMessage();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("project", this.project).add("changeId", this.changeId).add("commit", ChangeAndCommit.toString(this.commit)).add("_changeNumber", this._changeNumber).add("_revisionNumber", this._revisionNumber).add("_currentRevisionNumber", this._currentRevisionNumber).add("status", this.status).toString();
        }

        private static String toString(CommitInfo commit) {
            return MoreObjects.toStringHelper(commit).add("commit", commit.commit).add("parent", commit.parents).add("author", commit.author).add("committer", commit.committer).add("subject", commit.subject).add("message", commit.message).add("webLinks", commit.webLinks).toString();
        }
    }

    public static class RelatedInfo {
        public List<ChangeAndCommit> changes;
    }
}

