/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Ignore
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Ignore.class);
    private final StarredChangesUtil stars;

    @Inject
    Ignore(StarredChangesUtil stars) {
        this.stars = stars;
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Ignore").setTitle("Ignore the change").setVisible(this.canIgnore(rsrc));
    }

    public Response<String> apply(ChangeResource rsrc, Input input) throws RestApiException, OrmException, StarredChangesUtil.IllegalLabelException {
        try {
            if (rsrc.isUserOwner()) {
                throw new BadRequestException("cannot ignore own change");
            }
            if (!this.isIgnored(rsrc)) {
                this.stars.ignore(rsrc);
            }
            return Response.ok("");
        }
        catch (StarredChangesUtil.MutuallyExclusiveLabelsException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    private boolean canIgnore(ChangeResource rsrc) {
        return !rsrc.isUserOwner() && !this.isIgnored(rsrc);
    }

    private boolean isIgnored(ChangeResource rsrc) {
        try {
            return this.stars.isIgnored(rsrc);
        }
        catch (OrmException e) {
            log.error("failed to check ignored star", e);
            return false;
        }
    }

    public static class Input {
    }
}

