/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MarkAsReviewed
implements RestModifyView<ChangeResource, Input>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(MarkAsReviewed.class);
    private final Provider<ReviewDb> dbProvider;
    private final ChangeData.Factory changeDataFactory;
    private final StarredChangesUtil stars;

    @Inject
    MarkAsReviewed(Provider<ReviewDb> dbProvider, ChangeData.Factory changeDataFactory, StarredChangesUtil stars) {
        this.dbProvider = dbProvider;
        this.changeDataFactory = changeDataFactory;
        this.stars = stars;
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        return new UiAction.Description().setLabel("Mark Reviewed").setTitle("Mark the change as reviewed to unhighlight it in the dashboard").setVisible(!this.isReviewed(rsrc));
    }

    public Response<String> apply(ChangeResource rsrc, Input input) throws RestApiException, OrmException, StarredChangesUtil.IllegalLabelException {
        this.stars.markAsReviewed(rsrc);
        return Response.ok("");
    }

    private boolean isReviewed(ChangeResource rsrc) {
        try {
            return this.changeDataFactory.create(this.dbProvider.get(), rsrc.getNotes()).isReviewedBy(rsrc.getUser().asIdentifiedUser().getAccountId());
        }
        catch (OrmException e) {
            log.error("failed to check if change is reviewed", e);
            return false;
        }
    }

    public static class Input {
    }
}

