/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GerritServerConfigProvider;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.config.TrackingFootersProvider;
import com.google.gerrit.server.securestore.DefaultSecureStore;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.gerrit.server.securestore.SecureStoreProvider;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import java.io.IOException;
import java.nio.file.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public class GerritServerConfigModule
extends AbstractModule {
    public static String getSecureStoreClassName(Path sitePath) {
        if (sitePath != null) {
            return GerritServerConfigModule.getSecureStoreFromGerritConfig(sitePath);
        }
        String secureStoreProperty = System.getProperty("gerrit.secure_store_class");
        return GerritServerConfigModule.nullToDefault(secureStoreProperty);
    }

    private static String getSecureStoreFromGerritConfig(final Path sitePath) {
        AbstractModule m = new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(Path.class).annotatedWith(SitePath.class).toInstance(sitePath);
                this.bind(SitePaths.class);
            }
        };
        Injector injector = Guice.createInjector(m);
        SitePaths site = injector.getInstance(SitePaths.class);
        FileBasedConfig cfg = new FileBasedConfig(site.gerrit_config.toFile(), FS.DETECTED);
        if (!cfg.getFile().exists()) {
            return DefaultSecureStore.class.getName();
        }
        try {
            cfg.load();
            String className = cfg.getString("gerrit", null, "secureStoreClass");
            return GerritServerConfigModule.nullToDefault(className);
        }
        catch (IOException | ConfigInvalidException e) {
            throw new ProvisionException(e.getMessage(), e);
        }
    }

    private static String nullToDefault(String className) {
        return className != null ? className : DefaultSecureStore.class.getName();
    }

    @Override
    protected void configure() {
        this.bind(SitePaths.class);
        this.bind(TrackingFooters.class).toProvider(TrackingFootersProvider.class).in(Scopes.SINGLETON);
        this.bind(Config.class).annotatedWith(GerritServerConfig.class).toProvider(GerritServerConfigProvider.class).in(Scopes.SINGLETON);
        this.bind(SecureStore.class).toProvider(SecureStoreProvider.class).in(Scopes.SINGLETON);
    }
}

