/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.annotations.ExtensionPoint;
import com.google.gerrit.extensions.api.projects.ConfigValue;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtensionPoint
public class ProjectConfigEntry {
    private final String displayName;
    private final String description;
    private final boolean inheritable;
    private final String defaultValue;
    private final ProjectConfigEntryType type;
    private final List<String> permittedValues;

    public ProjectConfigEntry(String displayName, String defaultValue) {
        this(displayName, defaultValue, false);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, boolean inheritable) {
        this(displayName, defaultValue, inheritable, null);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, boolean inheritable, String description) {
        this(displayName, defaultValue, ProjectConfigEntryType.STRING, null, inheritable, description);
    }

    public ProjectConfigEntry(String displayName, int defaultValue) {
        this(displayName, defaultValue, false);
    }

    public ProjectConfigEntry(String displayName, int defaultValue, boolean inheritable) {
        this(displayName, defaultValue, inheritable, (String)null);
    }

    public ProjectConfigEntry(String displayName, int defaultValue, boolean inheritable, String description) {
        this(displayName, Integer.toString(defaultValue), ProjectConfigEntryType.INT, null, inheritable, description);
    }

    public ProjectConfigEntry(String displayName, long defaultValue) {
        this(displayName, defaultValue, false);
    }

    public ProjectConfigEntry(String displayName, long defaultValue, boolean inheritable) {
        this(displayName, defaultValue, inheritable, null);
    }

    public ProjectConfigEntry(String displayName, long defaultValue, boolean inheritable, String description) {
        this(displayName, Long.toString(defaultValue), ProjectConfigEntryType.LONG, null, inheritable, description);
    }

    public ProjectConfigEntry(String displayName, boolean defaultValue) {
        this(displayName, defaultValue, null);
    }

    public ProjectConfigEntry(String displayName, boolean defaultValue, String description) {
        this(displayName, Boolean.toString(defaultValue), ProjectConfigEntryType.BOOLEAN, null, false, description);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, List<String> permittedValues) {
        this(displayName, defaultValue, permittedValues, false);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, List<String> permittedValues, boolean inheritable) {
        this(displayName, defaultValue, permittedValues, inheritable, null);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, List<String> permittedValues, boolean inheritable, String description) {
        this(displayName, defaultValue, ProjectConfigEntryType.LIST, permittedValues, inheritable, description);
    }

    public <T extends Enum<?>> ProjectConfigEntry(String displayName, T defaultValue, Class<T> permittedValues) {
        this(displayName, defaultValue, permittedValues, false);
    }

    public <T extends Enum<?>> ProjectConfigEntry(String displayName, T defaultValue, Class<T> permittedValues, boolean inheritable) {
        this(displayName, defaultValue, permittedValues, inheritable, null);
    }

    public <T extends Enum<?>> ProjectConfigEntry(String displayName, T defaultValue, Class<T> permittedValues, boolean inheritable, String description) {
        this(displayName, defaultValue.name(), ProjectConfigEntryType.LIST, Arrays.stream((Enum[])permittedValues.getEnumConstants()).map(Enum::name).collect(Collectors.toList()), inheritable, description);
    }

    public ProjectConfigEntry(String displayName, String defaultValue, ProjectConfigEntryType type, List<String> permittedValues, boolean inheritable, String description) {
        this.displayName = displayName;
        this.defaultValue = defaultValue;
        this.type = type;
        this.permittedValues = permittedValues;
        this.inheritable = inheritable;
        this.description = description;
        if (type == ProjectConfigEntryType.ARRAY && inheritable) {
            throw new ProvisionException("ARRAY doesn't support inheritable values");
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ProjectConfigEntryType getType() {
        return this.type;
    }

    public List<String> getPermittedValues() {
        return this.permittedValues;
    }

    public boolean isEditable(ProjectState project) {
        return true;
    }

    public String getWarning(ProjectState project) {
        return null;
    }

    public ConfigValue preUpdate(ConfigValue configValue) {
        return configValue;
    }

    public String onRead(ProjectState project, String value) {
        return value;
    }

    public List<String> onRead(ProjectState project, List<String> values) {
        return values;
    }

    public void onUpdate(Project.NameKey project, String oldValue, String newValue) {
    }

    public void onUpdate(Project.NameKey project, Boolean oldValue, Boolean newValue) {
    }

    public void onUpdate(Project.NameKey project, Integer oldValue, Integer newValue) {
    }

    public void onUpdate(Project.NameKey project, Long oldValue, Long newValue) {
    }

    private static Boolean toBoolean(String value) {
        return value != null ? Boolean.valueOf(Boolean.parseBoolean(value)) : null;
    }

    private static Integer toInt(String value) {
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    private static Long toLong(String value) {
        return value != null ? Long.valueOf(Long.parseLong(value)) : null;
    }

    public static class UpdateChecker
    implements GitReferenceUpdatedListener {
        private static final Logger log = LoggerFactory.getLogger(UpdateChecker.class);
        private final GitRepositoryManager repoManager;
        private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;

        @Inject
        UpdateChecker(GitRepositoryManager repoManager, DynamicMap<ProjectConfigEntry> pluginConfigEntries) {
            this.repoManager = repoManager;
            this.pluginConfigEntries = pluginConfigEntries;
        }

        @Override
        public void onGitReferenceUpdated(GitReferenceUpdatedListener.Event event) {
            Project.NameKey p = new Project.NameKey(event.getProjectName());
            if (!event.getRefName().equals("refs/meta/config")) {
                return;
            }
            try {
                ProjectConfig oldCfg = this.parseConfig(p, event.getOldObjectId());
                ProjectConfig newCfg = this.parseConfig(p, event.getNewObjectId());
                if (oldCfg != null && newCfg != null) {
                    block7: for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                        ProjectConfigEntry configEntry = entry.getProvider().get();
                        String newValue = UpdateChecker.getValue(newCfg, entry);
                        String oldValue = UpdateChecker.getValue(oldCfg, entry);
                        if (newValue == null && oldValue == null || newValue != null && newValue.equals(oldValue)) {
                            return;
                        }
                        switch (configEntry.getType()) {
                            case BOOLEAN: {
                                configEntry.onUpdate(p, ProjectConfigEntry.toBoolean(oldValue), ProjectConfigEntry.toBoolean(newValue));
                                continue block7;
                            }
                            case INT: {
                                configEntry.onUpdate(p, ProjectConfigEntry.toInt(oldValue), ProjectConfigEntry.toInt(newValue));
                                continue block7;
                            }
                            case LONG: {
                                configEntry.onUpdate(p, ProjectConfigEntry.toLong(oldValue), ProjectConfigEntry.toLong(newValue));
                                continue block7;
                            }
                        }
                        configEntry.onUpdate(p, oldValue, newValue);
                    }
                }
            }
            catch (IOException | ConfigInvalidException e) {
                log.error("Failed to check if plugin config of project {} was updated.", (Object)p.get(), (Object)e);
            }
        }

        private ProjectConfig parseConfig(Project.NameKey p, String idStr) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
            ObjectId id = ObjectId.fromString(idStr);
            if (ObjectId.zeroId().equals(id)) {
                return null;
            }
            try (Repository repo = this.repoManager.openRepository(p);){
                ProjectConfig pc = new ProjectConfig(p);
                pc.load(repo, id);
                ProjectConfig projectConfig = pc;
                return projectConfig;
            }
        }

        private static String getValue(ProjectConfig cfg, DynamicMap.Entry<ProjectConfigEntry> e) {
            String value = cfg.getPluginConfig(e.getPluginName()).getString(e.getExportName());
            if (value == null) {
                value = e.getProvider().get().getDefaultValue();
            }
            return value;
        }
    }
}

