/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.server.config.TrackingFooter;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jgit.revwalk.FooterLine;

public class TrackingFooters {
    protected List<TrackingFooter> trackingFooters;

    public TrackingFooters(List<TrackingFooter> trFooters) {
        this.trackingFooters = trFooters;
    }

    public List<TrackingFooter> getTrackingFooters() {
        return this.trackingFooters;
    }

    public boolean isEmpty() {
        return this.trackingFooters.isEmpty();
    }

    public ListMultimap<String, String> extract(List<FooterLine> lines) {
        Multimap r = MultimapBuilder.hashKeys().arrayListValues().build();
        if (lines == null) {
            return r;
        }
        for (FooterLine footer : lines) {
            for (TrackingFooter config : this.trackingFooters) {
                if (!footer.matches(config.footerKey())) continue;
                Matcher m = config.match().matcher(footer.getValue());
                while (m.find()) {
                    String id = m.groupCount() > 0 ? m.group(1) : m.group();
                    if (id.isEmpty()) continue;
                    r.put(config.system(), id);
                }
            }
        }
        return r;
    }
}

